program ChngCase;

FUNCTION UpperCase( Strg: String ): String; Assembler;

ASM
           push ds         { Preserve data segment }
           lds si,strg     { Load DS:SI with Strg's address }
           les di,@result  { Load ES:DI with function result's addr}
           cld             { SI will be incremented }
           lodsb           { Get Strg's length, put in AL }
           stosb           { Store AL in ES:DI }
           xor ch,ch       { Clear CH }
           mov cl,al       { Put Strg's length into CL }
   @more:  lodsb           { Get next char in Strg, put into AL }
           cmp al,'a'      { Is it an 'a'? }
           jb @no          { If below 'a', go to @no }
           cmp al,'z'      { Is it a 'z'? }
           ja @no          { If above, also go to @no }
           sub al,20h      { It's in a..z, so subtract 20h }
   @no:    stosb           { Store AL in ES:DI }
   @loopy: loop @more      { If CX not zero, go to @more }
           pop ds          { Restore data segment }
END;


FUNCTION LowerCase( Strg: String ): String; Assembler;
ASM
           push ds         { Preserve data segment }
           lds si,strg     { Load DS:SI with Strg's address }
           les di,@result  { Load ES:DI with function result's addr }
           cld             { SI will be incremented }
           lodsb           { Get Strg's length, put in AL }
           stosb           { Store AL in ES:DI }
           xor ch,ch       { Clear CX }
           mov cl,al       { Put Strg's length into CL }
    @more: lodsb           { Get next char in Strg, put into AL }
           cmp al,'A'      { Is it an 'A'? }
           jb @no          { If below 'A', go to @no }
           cmp al,'Z'      { Is it a 'Z'? }
           ja @no          { If above, also go to @no }
           add al,20h      { It's in A..Z, so add 20h to 'lower' it }
   @no:    stosb           { Store AL in ES:DI }
   @loopy: loop @more      { If CX not zero, go to @more }
           pop ds          { Restore data segment }
END;

begin
  Writeln(UpperCase('Slowest'));
  Writeln(LowerCase('fASTEST'));
end.
