UNIT GetDrive;

INTERFACE

USES Dos;

FUNCTION GetValidDrives : LongInt;
FUNCTION GetRemovableDrives : LongInt;
FUNCTION GetSubstDrives : LongInt;
FUNCTION GetNetworkDrives : LongInt;

IMPLEMENTATION

  FUNCTION GetValidDrives;
  CONST
    SubstDrive = $8000;
    NetDrive = $1000;

  TYPE
    IDType = 'A'..'Z';
  VAR
    Reg : Registers;
    Ix : Integer;
    DriveSet : SET OF IDType;

  BEGIN
    DriveSet := [];
    FOR Ix := 1 TO 26 DO
      BEGIN
        Reg.Ax := $4409;
        Reg.Bl := Ix;
        MsDos(Reg);
        IF (Reg.Flags AND FCarry) = 0 THEN
          IF Reg.Dx AND (SubstDrive OR NetDrive) = 0 THEN
            DriveSet := DriveSet + [Chr(Ix + $40)];
      END;
    GetValidDrives := LongInt(DriveSet);
  END;

  FUNCTION GetRemovableDrives;
  TYPE
    IDType = 'A'..'Z';
  VAR
    Reg : Registers;
    Ix : Integer;
    DriveSet : SET OF IDType;

  BEGIN
    DriveSet := [];
    FOR Ix := 1 TO 26 DO
      BEGIN
        Reg.Ax := $4408;
        Reg.Bl := Ix;
        MsDos(Reg);
        IF (Reg.Flags AND FCarry) = 0 THEN
          IF Reg.Ax = 0 THEN
            DriveSet := DriveSet + [Chr(Ix + $40)];
      END;
    GetRemovableDrives := LongInt(DriveSet);
  END;

  FUNCTION GetSubstDrives;
  CONST
    SubstDrive = $8000;
    NetDrive = $1000;

  TYPE
    IDType = 'A'..'Z';
  VAR
    Reg : Registers;
    Ix : Integer;
    DriveSet : SET OF IDType;

  BEGIN
    DriveSet := [];
    FOR Ix := 1 TO 26 DO
      BEGIN
        Reg.Ax := $4409;
        Reg.Bl := Ix;
        MsDos(Reg);
        IF (Reg.Flags AND FCarry) = 0 THEN
          IF Reg.Dx AND (SubstDrive) <> 0 THEN
            DriveSet := DriveSet + [Chr(Ix + $40)];
      END;
    GetSubstDrives := LongInt(DriveSet);
  END;

  FUNCTION GetNetworkDrives;
  CONST
    SubstDrive = $8000;
    NetDrive = $1000;

  TYPE
    IDType = 'A'..'Z';
  VAR
    Reg : Registers;
    Ix : Integer;
    DriveSet : SET OF IDType;

  BEGIN
    DriveSet := [];
    FOR Ix := 1 TO 26 DO
      BEGIN
        Reg.Ax := $4409;
        Reg.Bl := Ix;
        MsDos(Reg);
        IF (Reg.Flags AND FCarry) = 0 THEN
          IF Reg.Dx AND (NetDrive) <> 0 THEN
            DriveSet := DriveSet + [Chr(Ix + $40)];
      END;
    GetNetworkDrives := LongInt(DriveSet);
  END;

END. { GetDrive }
