PROCEDURE TMyApp.InitMenuBar; (******** Based on TVGUID05.PAS *******)
VAR R       : TRect;
    TheMenu : PMenu; 
    ASub,BSub,ASubSub : PMenuItem;
BEGIN
{--------------------------------------------------------------------}
{              Create the base TMenu record for the menu bar.        }
{--------------------------------------------------------------------}
  TheMenu := NewMenuPtr;
{--------------------------------------------------------------------}
{          Create the first "submenu" for the "File" functions.      }
{--------------------------------------------------------------------}
  ASub := AddSubMenu(TheMenu,'~F~ile', hcNoContext);
{--------------------------------------------------------------------}
{           Create the first two "File" submenu entries...           }
{--------------------------------------------------------------------}
  AddMenuItem(ASub,'~O~pen','F3',kbF3,cmFileOpen,hcNoContext);
  AddMenuItem(ASub,'~N~ew', 'F4', kbF4, cmNewWin,hcNoContext);
{--------------------------------------------------------------------}
{            Add a separator line to the drop-down menu.             }
{--------------------------------------------------------------------}
  AddMenuLine(ASub);
{--------------------------------------------------------------------}
{               Add another menu item below the line.                }
{--------------------------------------------------------------------}
  AddMenuItem(ASub,'E~x~it', 'Alt-X', kbAltX, cmQuit,hcNoContext);
{--------------------------------------------------------------------}
{     Add a "Window" SUBMENU as an item under the "File" submenu,    }
{                    and add items to that submenu.                  }
{--------------------------------------------------------------------}
  ASubSub := AddMenuSub(ASub,'~W~indow', hcNoContext);
  AddMenuItem(ASubSub,'~N~ext', 'F6', kbF6, cmNext,hcNoContext);
  AddMenuItem(ASubSub,'~Z~oom', 'F5', kbF5, cmZoom,hcNoContext);
{--------------------------------------------------------------------}
{      Create the second "submenu" for the "Window" functions,       }
{                    and add items to that submenu.                  }
{--------------------------------------------------------------------}
  BSub := AddMenuSub(TheMenu,'~W~indow', hcNoContext);
  AddMenuItem(BSub,'~N~ext', 'F6', kbF6, cmNext,hcNoContext);
  AddMenuItem(BSub,'~Z~oom', 'F5', kbF5, cmZoom,hcNoContext);
{--------------------------------------------------------------------}
{      Create the MenuBar using the completed menu structure.        }
{--------------------------------------------------------------------}
  GetExtent(R);
  R.B.Y := R.A.Y + 1;
  MenuBar := New(PMenuBar, Init(R, TheMenu));
END;
{.pa}
PROCEDURE TMyApp.InitStatusLine;
VAR R: TRect;
    S: PStatusDef;
BEGIN
{--------------------------------------------------------------------}
{                Create the base status line definition.             }
{--------------------------------------------------------------------}
  S := AddStatusDef(0, $FFFF,NIL);
{--------------------------------------------------------------------}
{                      Add status line items.                        }
{--------------------------------------------------------------------}
  AddStatusItem(S,'', kbF10, cmMenu);
  AddStatusItem(S,'~Alt-X~ Exit', kbAltX, cmQuit);
  AddStatusItem(S,'~F4~ New', kbF4, cmNewWin);
  AddStatusItem(S,'~Alt-F3~ Close', kbAltF3, cmClose);
{--------------------------------------------------------------------}
{ Create the StatusLine, using the completed status line structure.  }
{--------------------------------------------------------------------}
  GetExtent(R);
  R.A.Y := R.B.Y - 1;
  StatusLine := New(PStatusLine, Init(R,S));
END;
