/*  TEST.C    Test the pointer validity testing. */

/*  include the required definitions
*/
#include    <windows.h>


/*  define a prototype for the valid pointer test
*/
extern  BOOL    FAR PASCAL  is_pointer_valid(LPVOID ptr);


/*  Report the type of test and whether the pointer
    is valid or not */
static  void    report(LPSTR title,LPVOID ptr)
{
    BOOL    is_valid;

    is_valid = is_pointer_valid(ptr);
    MessageBox(GetFocus(),(LPSTR) (is_valid ? "Valid" : "Invalid"),
                title,MB_OK);
}

/*  Program entry point for performing the test.
*/
int PASCAL  WinMain(HANDLE instance,HANDLE prev_instance,
                    LPSTR command_line,BOOL is_show)
{
    LPSTR       ptr;

    /* if the window already exists, bail
    */
    if (prev_instance)
        return(FALSE);

    /* test all classes of pointers and report whether
       they are valid or not */
    report((LPSTR) "Valid Pointer",(LPVOID) "Hello");
    report((LPSTR) "Invalid Selector",(LPVOID) NULL);
    report((LPSTR) "Code Pointer",(LPVOID) report);
    ptr = (LPSTR) "hello";
    ptr = (LPSTR) MAKELONG(0xffff,HIWORD(ptr));
    report((LPSTR) "Invalid Offset",(LPVOID) ptr);

    /* return back; we're done
    */
    return(0);
}
