///////////////////////////////////////////////////////////////
//  Windows Application Template
//      test.cxx
//
//      Written by Scott Robert Ladd
///////////////////////////////////////////////////////////////

#define STRICT

#include "test.h"
#include "wanimate.h"
#include "stdlib.h"

//-----------------------------
// external function prototypes
//-----------------------------

int PASCAL WinMain
    (
    HINSTANCE instance,
    HINSTANCE prevInst,
    LPSTR     cmdLine,
    int       cmdShow
    );

static BOOL InitApplication
    (
    HINSTANCE instance
    );

static BOOL InitInstance
    (
    HINSTANCE instance,
    int       cmdShow
    );

static void TermApplication();

LRESULT CALLBACK _export MainWndProc
    (
    HWND   wnd,
    UINT   msg,
    WPARAM wdata,
    LPARAM ldata
    );

//------------------------
// global constants
//------------------------

#define WM_ACTIVATEFIRST WM_USER

const int AnimOffX    = 50;
const int AnimOffY    = 50;
const int CelX        = 32;
const int CelY        = 32;
const int NoOfCels    =  8;

const DWORD StyleMain = WS_OVERLAPPEDWINDOW;

const char * TextTitle      = "Test: Animation";
const char * NameWndClsMain = "Test_WCMain";
const char * NameIcon       = "IconMain";
const char * NameMenu       = "MenuMain";
const char * NameDlgAbout   = "DLG_ABOUT";

const int CelNoPos = 6;

//------------------------
// global data
//------------------------

HINSTANCE ThisInstance;

HWND WndMain;

char * NameBmpCel = "BmpCel?";

BitmapAnimation Animation(NoOfCels,CelX,CelY);

//-------------------------------------------
//  WinMain -- program start and message loop
//-------------------------------------------

#ifdef __TURBOC__
    #pragma argsused
#endif

int PASCAL WinMain
    (
    HINSTANCE instance,
    HINSTANCE prevInst,
    LPSTR     cmdLine,
    int       cmdShow
    )
    {
    MSG message;

    // if already running, bring up existing instance
    if (prevInst)
        {
        HWND wnd = FindWindow(NameWndClsMain,NULL);

        PostMessage(wnd, WM_ACTIVATEFIRST, 0, 0L);
        return FALSE;
        }

    if (!InitApplication(instance))
        return 0;

    if (!InitInstance(instance, cmdShow))
        return 0;

    while (GetMessage(&message, NULL, NULL, NULL))
        {
        TranslateMessage(&message);
        DispatchMessage(&message);
        }

    TermApplication();

    return message.wParam;
    }

//--------------------------
// initialize an application
//--------------------------

static BOOL InitApplication
    (
    HINSTANCE instance
    )
    {
    WNDCLASS wc;

    // register class for main window
    wc.style         = CS_BYTEALIGNCLIENT;
    wc.lpfnWndProc   = MainWndProc;
    wc.cbClsExtra    = 0;
    wc.cbWndExtra    = 0;
    wc.hInstance     = instance;
    wc.hIcon         = LoadIcon(instance,NameIcon);;
    wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH)GetStockObject(GRAY_BRUSH);
    wc.lpszMenuName  = NameMenu;
    wc.lpszClassName = NameWndClsMain;

    return RegisterClass(&wc);
    }

//-----------------------
// initialize an instance
//-----------------------

static BOOL InitInstance
    (
    HINSTANCE instance,
    int       cmdShow
    )
    {
    // save the instance handle
    ThisInstance = instance;

    // create the main window
    WndMain = CreateWindow(NameWndClsMain,
                           TextTitle,
                           StyleMain,
                           CW_USEDEFAULT,
                           CW_USEDEFAULT,
                           CW_USEDEFAULT,
                           CW_USEDEFAULT,
                           NULL,
                           NULL,
                           instance,
                           0);

    if (!WndMain)
        return FALSE;

    ShowWindow(WndMain, cmdShow);
    UpdateWindow(WndMain);

    // fill animation with bitmaps
    HBITMAP cel;

    for (int i = 1; i <= NoOfCels; ++i)
        {
        NameBmpCel[CelNoPos] = (char)'0' + (char)i;

        cel = LoadBitmap(ThisInstance,NameBmpCel);

        Animation.Append(cel);

        DeleteObject(cel);
        }

    // display first cell
    HDC dc = GetDC(WndMain);

    Animation.ShowCel(dc,AnimOffX,AnimOffY);

    ReleaseDC(WndMain,dc);

    return TRUE;
    }

void TermApplication()
    {
    UnregisterClass(NameWndClsMain, ThisInstance);
    }

LRESULT CALLBACK _export MainWndProc
    (
    HWND   wnd,
    UINT   msg,
    WPARAM wdata,
    LPARAM ldata
    )
    {
    HDC dc;

    switch (msg)
        {
        case WM_COMMAND:
            switch (wdata)
                {
                case IDM_ANIM_PLAY:
                    dc = GetDC(wnd);

                    Animation.Play(dc,AnimOffX,AnimOffY);

                    ReleaseDC(wnd,dc);
                    break;

                case IDM_ANIM_REWIND:
                    Animation.Rewind();

                    dc = GetDC(wnd);

                    Animation.ShowCel(dc,AnimOffX,AnimOffY);

                    ReleaseDC(wnd,dc);
                    break;

                case IDM_ANIM_NEXT:
                    dc = GetDC(wnd);

                    Animation.Step(dc,AnimOffX,AnimOffY);

                    ReleaseDC(wnd,dc);
                    break;
                    
                case IDM_EXIT:
                    DestroyWindow(wnd);
                    break;

                default:
                    return DefWindowProc(wnd, msg, wdata, ldata);
                }

            break;

        case WM_ACTIVATEFIRST:
            if (IsIconic(wnd))
                ShowWindow(wnd,SW_RESTORE);
            else
                SetActiveWindow(wnd);

            break;

        case WM_PAINT:
            PAINTSTRUCT ps;

            dc = BeginPaint(wnd,&ps);

            Animation.ShowCel(dc,AnimOffX,AnimOffY);

            EndPaint(wnd,&ps);

            break;

        case WM_CLOSE:
            DestroyWindow(wnd);
            break;

        case WM_DESTROY:
            PostQuitMessage(0);
            break;

        default:
            return DefWindowProc(wnd, msg, wdata, ldata);
        }

    return 0L;
    }

