///////////////////////////////////////////////////////////////
//  WINDOWS ANIMATION CLASS
//      wanimate.h
//
//      This class defines a set of bitmaps as an animation.
//
//      Copyright 1992 by Scott Robert Ladd. 
//      All Rights Reserved. 
///////////////////////////////////////////////////////////////

#ifndef WANIMATE_H
#define WANIMATE_H

#define STRICT

#ifdef _MSC_VER
    #pragma warning(disable:4100 4505)
#endif

#include "windows.h"
#include "stdlib.h"

class BitmapAnimation
    {
    public:
        // constructor
        BitmapAnimation
            (
            size_t max, 
            int    celx, 
            int    cely
            );

        BitmapAnimation
            (
            const BitmapAnimation & anim
            );

        // destructor
        ~BitmapAnimation();

        // assignment operator
        void operator = 
            (
            const BitmapAnimation & anim
            );

        // add bitmaps
        BOOL Append
            (
            HBITMAP cel
            );

        // run bitmap from current position to end
        void Play
            (
            HDC dc, 
            int x, 
            int y
            );

        // go to next cell
        BOOL Step
            (
            HDC dc, 
            int x, 
            int y
            );

        // display current cell
        BOOL ShowCel
            (
            HDC dc, 
            int x, 
            int y
            );

        // rewind to beginning
        void Rewind();

        // set dealy used in Run... functions
        DWORD SetSpeed
            (
            DWORD millisec
            );

    private:
        void CopyFilm
            (
            const BitmapAnimation & anim
            );

        void Sleep();

        int CelHeight;
        int CelWidth;

        size_t MaxCels;
        size_t NoOfCels;
        size_t LastCel;
        size_t CurrentCel;

        DWORD DelayTime;

        static const DWORD DefaultDelay;

        HBITMAP Film;
    };

// rewind to beginning
inline void BitmapAnimation::Rewind()
    {
    CurrentCel = 0;
    }

// set dealy used in Run... functions
inline DWORD BitmapAnimation::SetSpeed
    (
    DWORD millisec
    )
    {
    DWORD result = DelayTime;

    DelayTime = millisec;

    return result;
    }

#endif
