// ontop.cpp -- Stay on top demonstration

#include <owl.h>              // Include ObjectWindows header
#include "ontop.rch"          // Include resource declarations
#define EM_SILENTABORT 999    // Silent abort error message
LPSTR lpstrClassName = "TOnTopWin";  // Main window class name

// The application class
class TOnTopApp: public TApplication {
public:
  TOnTopApp(LPSTR AName, HINSTANCE AnInstance,
    HINSTANCE APrevInstance, LPSTR ACmdLine, int ACmdShow)
    : TApplication(AName, AnInstance, APrevInstance,
      ACmdLine, ACmdShow) {};
  virtual void Error(int ErrorCode);
  virtual void InitMainWindow();
  virtual void InitInstance();
};

// Main window class
class TOnTopWin: public TWindow {
  BOOL topmost;  // True if window is set to stay on top
public:
  TOnTopWin(PTWindowsObject AParent, LPSTR ATitle);
  virtual LPSTR GetClassName()
    { return lpstrClassName; }
  virtual void CMFileExit(RTMessage)
    = [CM_FIRST + CM_FILE_EXIT];
  virtual void CMSettingStay(RTMessage)
    = [CM_FIRST + CM_SETTING_STAY];
};

// Handle application errors
void TOnTopApp::Error(int ErrorCode)
{
  if (ErrorCode == EM_SILENTABORT)
    PostAppMessage(GetCurrentTask(), WM_QUIT, 0, 0);
  else
    TApplication::Error(ErrorCode);
}

// Initialize main window
void TOnTopApp::InitMainWindow()
{
  MainWindow = new TOnTopWin(NULL, "Stay On Top Demonstration");
}

// Initialize every program instance
void TOnTopApp::InitInstance()
{
  if (hPrevInstance) {
    HWND hwnd = FindWindow(lpstrClassName, NULL);
    if (hwnd) {
      BringWindowToTop(hwnd);
      ShowWindow(hwnd, SW_RESTORE);
      Status = EM_SILENTABORT;
    } else
      Status = EM_INVALIDMODULE;
  } else
    TApplication::InitInstance();
}

// Construct main window object
TOnTopWin::TOnTopWin(PTWindowsObject AParent, LPSTR ATitle)
  : TWindow(AParent, ATitle)
{
  AssignMenu(ID_MENU);
  Attr.ExStyle |= WS_EX_TOPMOST;
  topmost = TRUE;
}

// Respond to File|Exit command: exit program
void TOnTopWin::CMFileExit(RTMessage)
{
  CloseWindow();
}

// Respond to Setting|Stay on top command: toggle setting
void TOnTopWin::CMSettingStay(RTMessage)
{
  HWND hwndInsertAfter;
  WORD wCheck;

  if (topmost) {
    wCheck = MF_BYCOMMAND | MF_UNCHECKED;
    hwndInsertAfter = HWND_NOTOPMOST;
  } else {
    wCheck = MF_BYCOMMAND | MF_CHECKED;
    hwndInsertAfter = HWND_TOPMOST;
  }
  SetWindowPos(HWindow, hwndInsertAfter, 0, 0, 0, 0,
    SWP_NOMOVE | SWP_NOSIZE);
  CheckMenuItem(GetMenu(HWindow), CM_SETTING_STAY, wCheck);
  topmost = !topmost;
}

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
  LPSTR lpszCmdLine, int nCmdShow)
{
  TOnTopApp OnTopApp("OnTopApp", hInstance, hPrevInstance,
    lpszCmdLine, nCmdShow);
  OnTopApp.Run();
  return OnTopApp.Status;
}
