(* ----------------------------------------------------------- *(
**  which.pas -- Finds executable pathname                     **
** ----------------------------------------------------------- **
**                                                             **
**  Use WHICH to find out which of several possible            **
**  programs will execute if you enter their names at a        **
**  DOS prompt. For example, if you have a few copies of       **
**  grep.com on your hard drive, enter WHICH GREP to find      **
**  out which one will run if you type GREP <argument>.        **
**                                                             **
**  The program looks for programs in the current directory    **
**  and in all directories on the current PATH. It             **
**  recognizes DOS's default execution order of .COM,          **
**  .EXE, and .BAT files, in that order.                       **
**                                                             **
** ----------------------------------------------------------- **
**     Copyright (c) 1993 by Tom Swan. All rights reserved.    **
)* ----------------------------------------------------------- *)

program Which; uses Dos;

function Search(var Target, Path, Result: String): Boolean;
  function FileFound(F: String): Boolean;
  begin
    Result := FSearch(F, Path);
    FileFound := Length(Result) > 0
  end;
begin
  if Pos('.', Target) > 0 then
    Search := FileFound(Target)
  else begin
    Search := True;
    if not FileFound(Target + '.COM') then
    if not FileFound(Target + '.EXE') then
    if not FileFound(Target + '.BAT') then
      Search := False
  end
end;

function NextPath(var Path: String): String;
var
  P: Byte;
begin
  P := Pos(';', Path);
  if P = 0 then
  begin
    NextPath := Path;
    Path := ''
  end else
  begin
    NextPath := Copy(Path, 1, P - 1);
    Delete(Path, 1, P)
  end
end;

procedure Instruct;
begin
  Writeln;
  Writeln('WHICH.EXE');
  Writeln('Copyright (C) 1993 by Tom Swan.');
  Writeln;
  Writeln('Enter WHICH NAME to find which executable code');
  Writeln('file--NAME.COM, NAME.EXE, or NAME.BAT--would be');
  Writeln('executed if you type NAME at a DOS prompt.');
  Halt
end;

var
  I: Integer;
  Found: Boolean;
  Target, SysPath, Path, Result: String;

begin
  if ParamCount < 1 then Instruct;
  Target := ParamStr(1);
  for I := 1 to Length(Target) do
    Target[I] := Upcase(Target[I]);
  SysPath := GetEnv('PATH');
  Path := '';  { Current directory }
  Found := Search(Target, Path, Result);
  while (not Found and (Length(SysPath) > 0)) do
  begin
    Path := NextPath(SysPath);
    Found := Search(Target, Path, Result)
  end;
  if Found
    then Writeln(Result)
    else Writeln(Target, ' not found')
end.


(*
// --------------------------------------------------------------
// Copyright (c) 1993 by Tom Swan. All rights reserved
// Revision 1.00    Date: 07/03/1992   Time: 04:16 pm
// Revision 2.00    Date: 03/04/1993   Time: 07:46 am
// - Fixed bugs in earlier version (complete rewrite)
*)
