       IDENTIFICATION DIVISION.
       PROGRAM-ID.                     TSCPRESS.
       AUTHOR.                         TOM SALWASSER.
      * IMPLEMENTATION OF BASE 40 COMPRESSION AS DESCRIBED IN
      * PC TECHNIQUES MAGAZINE JUNE / JULY 1993 ISSUE.
       INSTALLATION.                   SALSOFT.
       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.
       SOURCE-COMPUTER.                IBM-PC.
       OBJECT-COMPUTER.                IBM-PC.
       DATA DIVISION.
       WORKING-STORAGE SECTION.
       01   CODE-TABLE-DATA.
            05  FILLER PIC X(21) VALUE " 01,02.03004105206307".
            05  FILLER PIC X(21) VALUE "408509610711812913A14".
            05  FILLER PIC X(21) VALUE "B15C16D17E18F19G20H21".
            05  FILLER PIC X(21) VALUE "I22J23K24L25M26N27O28".
            05  FILLER PIC X(21) VALUE "P29Q30R31S32T33U34V35".
            05  FILLER PIC X(12) VALUE "W36X37Y38Z39".
       01   CODE-TABLE-HOLDER REDEFINES CODE-TABLE-DATA.
            05 CODE-TABLE OCCURS 39 TIMES
                          ASCENDING KEY CT-DATA
                          INDEXED BY CI.
               10  CT-DATA            PIC X.
               10  CT-CODE            PIC 99.
       01   RESULT-TABLE.
            05   RT             PIC XX COMP-X OCCURS 4 TIMES.
       01   FIRST-TIME-FLAG            PIC X VALUE "Y".
            88 FIRST-TIME           VALUE "Y".
       LINKAGE SECTION.
       01   LINK-FLAG                  PIC X.
            88  NEED-COMPRESS   VALUE "3".
            88  NEED-DECOMPRESS VALUE "2".
       01   LINK-DECOMP.
            05  BYTES-3          PIC X OCCURS 3 TIMES.
       01   LINK-COMP            PIC XX USAGE IS COMP-X.
       PROCEDURE DIVISION USING LINK-FLAG LINK-DECOMP LINK-COMP.
       MAINLINE.
           IF FIRST-TIME
               MOVE "N" TO FIRST-TIME-FLAG
               DISPLAY "TSCPRESS V.08/14/93" LINE 2 POSITION 1.
           IF NEED-COMPRESS
               PERFORM COMPRESS-IT THRU COMPRESS-IT-X
           ELSE
           IF NEED-DECOMPRESS
               PERFORM DECOMPRESS-IT THRU DECOMPRESS-IT-X
           ELSE
               DISPLAY "INVALID COMPRESS FLAG."
               DISPLAY "MUST 3 OR 2. VALUE: " LINK-FLAG
               DISPLAY "JOB ABENDING"
               STOP RUN.
       MAINLINE-X.
           EXIT PROGRAM.
       COMPRESS-IT.
           SEARCH ALL CODE-TABLE AT END MOVE 1 TO RT (1)
                  WHEN CT-DATA (CI) = BYTES-3 (1)
                       MOVE CT-CODE (CI) TO RT (1).
           SEARCH ALL CODE-TABLE AT END MOVE 1 TO RT (2)
                  WHEN CT-DATA (CI) = BYTES-3 (2)
                       MOVE CT-CODE (CI) TO RT (2).
           SEARCH ALL CODE-TABLE AT END MOVE 1 TO RT (3)
                  WHEN CT-DATA (CI) = BYTES-3 (3)
                       MOVE CT-CODE (CI) TO RT (3).
           COMPUTE LINK-COMP =
                   (((RT(1) * 1600) + (RT(2) * 40) + RT(3))).
       COMPRESS-IT-X.
           EXIT.
       DECOMPRESS-IT.
           MOVE LINK-COMP TO RT (4) RT (1).
           DIVIDE RT (1) BY 1600.
           COMPUTE RT (2) = (RT (4) - (RT (1) * 1600)).
           DIVIDE RT (2) BY 40.
           COMPUTE RT (3) = (RT (4)-((RT (1)*1600)+(RT (2)*40))).
           SET CI TO RT (1).
           MOVE CT-DATA (CI) TO BYTES-3 (1).
           SET CI TO RT (2).
           MOVE CT-DATA (CI) TO BYTES-3 (2).
           SET CI TO RT (3).
           MOVE CT-DATA (CI) TO BYTES-3 (3).
       DECOMPRESS-IT-X.
           EXIT.
