{ FSPOLTST.PAS }
{
Description:  Demonstration program for Spool object.
Author:       Don Taylor
Date:         20 January 1993
Last revised: 23 July 1993 12:15
Application:  IBM PC and compatibles; BP7.0; TV2.0
}
program TestFileSpooler;

uses
 Dos, Crt, Objects, Drivers, Views, Menus,
 Dialogs, MsgBox, FSpooler, App;

 { Command constants }
const
 cmPrintNormal   =   198;
 cmPrintModal    =   199;
 cmPrintHidden   =   200;

 { Internal message constants }
 msPrintComplete =  1001;

 { Miscellaneous }
 SpoolFileName = '$SPOOLER$.$$$';

type
 PSCollection = ^TSCollection;
 TSCollection = object(TCollection)
  constructor Init(ALimit, ADelta : Integer);
  procedure FreeItem(Item : Pointer); virtual;
 end; { object }

 PPrintApp = ^TPrintApp;
 TPrintApp = object(TApplication)
  PColl       : PSCollection;
  TheSpooler  : PFileSpooler;
  TestWin     : PWindow;
  constructor Init;
  procedure InitMenubar; virtual;
  destructor Done; virtual;
  procedure PrintNormal; virtual;
  procedure PrintModal; virtual;
  procedure PrintHidden; virtual;
  procedure HandleEvent(var Event : TEvent); virtual;
  procedure Idle; virtual;
 private
  procedure InitPrintData(var PD : FileSpoolJobRec);
  procedure PrintToFile;
 end; { object }

var
 MyApp  : TPrintApp;

{ ///// TSCollection Methods ///// }
constructor TSCollection.Init(ALimit, ADelta : Integer);
begin
 TCollection.Init(ALimit, ADelta);
end; { TSCollecton.Init }

procedure TSCollection.FreeItem(Item : Pointer);
begin
 if Item <> nil then DisposeStr(Item);
end; { TSCollection.FreeItem }

{ ///// TPrintApp Methods ///// }
constructor TPrintApp.Init;
var
 i  : Integer;
 s  : String;
 p  : PString;
 R  : TRect;
 PB : PButton;
begin
 TApplication.Init;
 R.Assign(21, 4, 56, 11);
 TheSpooler  := New(PFileSpooler, Init(R, 'My Spooler'));
 with TheSpooler^ do
  begin
   R.Assign(3, Size.Y - 3, 15, Size.Y - 1);
   PB := New(PButton, Init(R, '~C~ancel', cmSpoolCancelPrint, bfDefault));
   PB^.Options := PB^.Options or ofCenterX;
   Insert(PB);
  end; { with }
 Desktop^.Insert(TheSpooler);

 PColl := New(PSCollection, Init(100, 10));
 for i := 1 to 100 do
  begin
   Str(i, s);
   p := NewStr('This is line ' + s);
   PColl^.Insert(p);
  end; { for }

 R.Assign(10, 3, 40, 10);
 TestWin := New(PWindow, Init(R, 'Test Window', wnNoNumber));
 Desktop^.Insert(TestWin);

end; { TPrintApp.Init }

procedure TPrintApp.InitMenubar;
var
 R : TRect;
begin
 GetExtent(R);
 R.B.Y := R.A.Y + 1;
 Menubar := New(PMenubar, Init(R, NewMenu(
  NewSubMenu('~P~rint', hcNoContext, NewMenu(
   NewItem('~N~ormal', 'F2', kbF2, cmPrintNormal, hcNoContext,
   NewItem('~M~odal',  'F3', kbF3, cmPrintModal,  hcNoContext,
   NewItem('~H~idden', 'F4', kbF4, cmPrintHidden, hcNoContext,
   NewLine(
   NewItem('E~x~it', '', kbAltX, cmQuit, hcNoContext,
   nil)))))),
  nil)
 )));
end; { TPrintApp.InitMenubar }

destructor TPrintApp.Done;
begin
 TApplication.Done;
 Dispose(PColl, Done);
end; { TPrintApp.Done }

procedure TPrintApp.PrintNormal;
var PData : FileSpoolJobRec;
begin
 if not TheSpooler^.Printing
  then begin
        InitPrintData(PData);
        PrintToFile;
        if TheSpooler^.Start(PData) = SpoolOK
         then begin
               DisposeStr(TheSpooler^.Title);
               TheSpooler^.Title := NewStr('Non-Modal Spooler');
               TheSpooler^.MoveTo(12, 8);
               TheSpooler^.SetState(sfSelected, True);
               TheSpooler^.MakeFirst;
               TheSpooler^.Show;
              end
         else begin
               TheSpooler^.Pause;
               MessageBox(#3 + 'Non-modal print: Printer error.',
                 nil, mfError + mfOKButton);
               TheSpooler^.Resume;
              end;
       end
  else begin
        TheSpooler^.Pause;
        MessageBox(#3 + 'Non-modal print: Printer busy.',
          nil, mfError + mfOKButton);
        TheSpooler^.Resume;
       end;
end; { TPrintApp.PrintNormal }

procedure TPrintApp.PrintModal;
var
 PData  : FileSpoolJobRec;
 Result : Integer;
begin
 if not TheSpooler^.Printing
  then begin
        InitPrintData(PData);
        PrintToFile;
        if TheSpooler^.Start(PData) = SpoolOK
         then begin
               DisposeStr(TheSpooler^.Title);
               TheSpooler^.Title := NewStr('Modal Spooler');
               TheSpooler^.MoveTo(30, 12);
               TheSpooler^.MakeFirst;
               TheSpooler^.Show;
               Result := Desktop^.ExecView(TheSpooler);
               case Result of
                cmSpoolPrintCancelled : begin
                                         MessageBox(#3 + 'Modal print: Cancelled.',
                                           nil, mfWarning or mfOKButton);
                                         TheSpooler^.Hide;
                                        end;
                cmSpoolPrintComplete  : begin
                                         TheSpooler^.Hide;
                                         MessageBox(#3 + 'Modal print: Done.',
                                           nil, mfInformation or mfOKButton);
                                        end;
               end; { case }
              end
         else begin
               TheSpooler^.Pause;
               MessageBox(#3 + 'Modal print: Printer error.',
                nil, mfError + mfOKButton);
               TheSpooler^.Resume;
              end;
       end
  else begin { Spooler is already printing }
        TheSpooler^.Pause;
        MessageBox(#3 + 'Modal print: Printer busy.',
          nil, mfError + mfOKButton);
        TheSpooler^.Resume;
       end;
end; { TPrintApp.PrintModal }

procedure TPrintApp.PrintHidden;
var PData : FileSpoolJobRec;
begin
 if not TheSpooler^.Printing
  then begin
        InitPrintData(PData);
        PrintToFile;
        if TheSpooler^.Start(PData) <> SpoolOK
         then begin
               TheSpooler^.Pause;
               MessageBox(#3 + 'Hidden print: Printer error.',
                 nil, mfError + mfOKButton);
               TheSpooler^.Resume;
              end;
       end
  else begin { Spooler is already printing }
        TheSpooler^.Pause;
        MessageBox(#3 + 'Hidden print: Printer busy.',
          nil, mfError + mfOKButton);
        TheSpooler^.Resume;
       end;
end; { TPrintApp.PrintHidden }

procedure TPrintApp.Idle;
begin
 TApplication.Idle;
 if TheSpooler^.Update = cmSpoolPrintComplete
  then Message(@Self, evBroadcast, msPrintComplete, nil);
end; { TPrintApp.Idle }

procedure TPrintApp.HandleEvent(var Event : TEvent);
begin
 case Event.What of
  evCommand :
   case Event.Command of
    cmQuit        : if TheSpooler^.Printing
                     then begin
                           TheSpooler^.Pause;
                           if MessageBox(#3 + 'Abandon print job (Y/N)? ',
                                nil, mfConfirmation or mfYesButton or mfNoButton) = cmYes
                            then begin
                                  TheSpooler^.Cancel;
                                  TheSpooler^.Hide;
                                 end
                            else begin
                                  ClearEvent(Event);
                                  TheSpooler^.Resume;
                                  Exit;
                                 end;
                          end;

    cmSpoolCancelPrint : begin
                          TheSpooler^.Cancel;
                          MessageBox(#3 + 'Non-modal print: Job cancelled.',
                            nil, mfWarning or mfOKbutton);
                          TheSpooler^.Hide;
                          ClearEvent(Event);
                         end;

    cmPrintNormal : begin PrintNormal; ClearEvent(Event); end;
    cmPrintModal  : begin PrintModal;  ClearEvent(Event); end;
    cmPrintHidden : begin PrintHidden; ClearEvent(Event); end;
   end; { case }
  evBroadcast :
   case Event.Command of
    msPrintComplete  : begin
                        TheSpooler^.Hide;
                        MessageBox(#3 + 'Print job done.',
                          nil, mfInformation or mfOKButton);
                        ClearEvent(Event);
                       end;
   end; { case }
 end; { case }
 TApplication.HandleEvent(Event);
end; { TPrintApp.HandleEvent }

procedure TPrintApp.InitPrintData(var PD : FileSpoolJobRec);
begin
 PD.FName         := SpoolFileName;
 PD.PNum          := 0; { LPT1 }
 PD.EraseOnCancel := False;
 PD.EraseWhenDone := True;
end; { TPrintApp.InitPrintData }

procedure TPrintApp.PrintToFile;
var
 F : Text;
 procedure PrintItem(Item : Pointer); far;
 begin
  Writeln(F, String(Item^));
 end;
begin
 Assign(F, SpoolFileName);
 SetFAttr(F, 0);
 Rewrite(F);
 PColl^.ForEach(@PrintItem);
 Close(F);
 SetFAttr(F, Hidden);
end; { TPrintApp.PrintToFile }

begin { TestFileSpooler }
 MyApp.Init;
 MyApp.Run;
 MyApp.Done;
end. { TestFileSpooler }