{  MULTISRT.PAS: TMultiSortCollection Object definition }
Unit MultiSrt;

Interface

Uses Objects;

Type
  SortType = (Ascending, Descending);

  PMultiSortCollection = ^TMultiSortCollection;
  TMultiSortCollection = Object (TSortedCollection)
    SortKey : Integer;
    SortOrder : SortType;
    Constructor Init (ALimit, ADelta, KeyNo : Integer;
                      Order : SortType);
    Procedure Sort (KeyNo : Integer; Order : SortType);
  End;

Implementation

Constructor TMultiSortCollection.Init (ALimit, ADelta,
              KeyNo : Integer; Order : SortType);
Begin
  Inherited Init (ALimit, ADelta);
  SortKey := KeyNo;
  SortOrder := Order;
End;

Procedure TMultiSortCollection.Sort (KeyNo : Integer;
                                     Order : SortType);
Var
  x,y : Integer;
  Temp : Pointer;

  Procedure QuickSort (Left, Right : Integer);
  Var
    i, j : Integer;
    x, Temp : Pointer;
  Begin
    i := Left;
    j := Right;
    x := At ((Left+Right) div 2);
    Repeat
      While Compare (At (i), x) < 0 Do Inc (i);
      While Compare (x, At (j)) < 0 Do Dec (j);
      If i <= j Then Begin
        Temp := At (i);
        AtPut (i, At (j));
        AtPut (j, Temp);
        Inc (i);
        Dec (j);
      End;
    Until i > j;
    If Left < j Then QuickSort (Left, j);
    If i < Right Then QuickSort (i, Right);
  End;

Begin
  SortKey := KeyNo;
  SortOrder := Order;
  QuickSort (0, Count-1);
End;

End.
