/***********************************************************************
*                              PRINTER.C
*   PRINTER is a private-library module for OS/2 C.  Calling printset()
* opens the spooler (if attached to the LPT1 port) and allows the
* function lprint(char *string) to send the text of the string argument
* to the line printer. 
*   USAGE: Include printer.h with any module using printer output.  Call
* printset() from the "main" module before any requests for output
* printing.  To print string <text> use: lprint(text).
*  Written by M. L. Lesser, 7/19/93, for Borland BCC for OS/2, v 1.00
***********************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

static FILE *printer;
static unsigned char INIT[] = { 27,58,27,88,12,91 };

/* INIT is a sequence of control characters to modify the default
*  printer setup.  This version sets a wide-carriage
*  ProPrinter-compatible printer to 12-pitch, 80-character lines
*  centered on 8.5-inch wide paper.
*/

static void closeprn(void)              /* Auto-called at exit */
{
    fclose(printer);
}

void printset()         /* Initialize printer */
{
    printer = fopen("PRN","wb");
    fwrite(&INIT, sizeof(INIT), 1, printer);
    atexit(closeprn);
}

void lprint(char *string)       /* Print string on line printer */
{
    int  i,j;
    char text[90];
    
    j = 0;
    for (i = 0; i <= strlen(string); i++)  {    /* Convert string to */
        if (string[i] != '\n')                  /*   "binary" format */
            text[j++] = string[i];
        else {
            text[j++] = '\r';
            text[j++] = '\n';
        }
    }
    fwrite(text, strlen(text), 1, printer);
}
