/* Bitmap viewer that uses Microsoft QuickWin */
/* Compile as QuickWin App from IDE or use -Mq option from
   command line. If you use VC++ from a CDROM, you may
   need to copy \MSVC\BIN\CL.DEF from your CD to your
   hard disk */
#include <stdio.h>
#include <io.h>
#include <malloc.h>
#include <stdlib.h>
#include <graph.h>

/* Microsoft graphics modes */
struct
  {
  unsigned int x;
  unsigned int y;
  unsigned int color;
  int mode;
  } modetbl[]=
    {
    {320,200,4,_MRES4COLOR},
    {640,200,2,_HRESBW},
    {320,200,16,_MRES16COLOR},
    {640,200,16,_HRES16COLOR},
    {640,350,2,_ERESNOCOLOR},
    {640,350,16,_ERESCOLOR},
    {640,480,2,_VRES2COLOR},
    {640,480,16,_VRES16COLOR},
    {320,200,256,_MRES256COLOR},
    {640,400,256,_ORES256COLOR},
    {640,480,256,_VRES256COLOR},
    {800,600,16,_SRES16COLOR},
    {800,600,256,_SRES256COLOR},
    {1024,768,16,_XRES16COLOR},
    {1024,768,256,_XRES256COLOR},
    {1280,1024,16,_ZRES16COLOR},
    {1280,1024,256,_ZRES256COLOR}
    };


int disp(char *);
int matchmode(unsigned long,unsigned long,unsigned int);


main(int argc,char *argv[])
  {
  printf("Quick BMP Viewer by Al Williams\n");
  _wsetexit(_WINEXITNOPERSIST);  /* don't wait around */
  if (argc==1)  /* prompt for file names */
    {
    while (1)
      {
      char filenam[66];
      printf("File: ");
      scanf("%s",filenam);    /* read file name */
      disp(filenam);          /* show it */
      }
    }
  else   /* batch mode */
   {
    /* destroy standard window */
    _wclose(_fileno(stdout),_WINNOPERSIST);
    while (--argc)
       {
       disp(*++argv);
       _inchar();
       }
    }
  exit(0);
  }

/* Display file */
disp(char *filen)
  {
  FILE *f=fopen(filen,"rb");
  char _huge *image;
  unsigned long len,i;
  unsigned long x,y;
  unsigned int colors;
  unsigned int j;
  int mode;
  unsigned long _huge *ctbl;
  if (!f)
    {
    printf("Can't open file\n");
    return 1;
    }
  image=halloc(len=_filelength(_fileno(f)),1);
  if (!image)
    {
    printf("Out of memory\n");
    fclose(f);
    return 1;
    }
/* read file -- since huge, can't use fread */
  for (i=0;i<len;i++)
    image[i]=getc(f);
  fclose(f);
/* find dimensions */
  x=*(unsigned long _huge *)(image+18);
  y=*(unsigned long _huge *)(image+22);
/* find number of colors */
  colors=1<<(*(unsigned int _huge *)(image+28));
/* find closest mode */
  mode=matchmode(x,y,colors);
  _wgclose(_wggetactive());   /* kill current window */
  _wgsetactive(_wgopen(filen));  /* make new one */
  _setvideomode(mode);
  ctbl=                         /* palette table */
     (unsigned long _huge *)(image+14+
     *(unsigned long _huge *)(image+14));
  for (j=0;j<colors;j++)   /* set palette */
    {
    union
      {
      unsigned char byte[4];
      unsigned long quad;
      } rgb;
    int swap;
    rgb.quad=*ctbl++;
    swap=rgb.byte[0];
    rgb.byte[0]=rgb.byte[2];
    rgb.byte[2]=swap;
    _remappalette(j,rgb.quad);
    }
  _putimage(0,0,image,_GPSET);   /* draw! */
  hfree(image);
  return 0;
  }

/* Find closest mode */
matchmode(unsigned long x,unsigned long y,unsigned int colors)
  {
  int i;
  int err=9999;
  int mode=_ZRES256COLOR;  /* default */
  for (i=0;i<sizeof(modetbl)/sizeof(modetbl[0]);i++)
    {
    if (modetbl[i].x>=x&&modetbl[i].y>=
        y&&modetbl[i].color>=colors)
      {
      int try;
      if (err>(try=(int)(modetbl[i].x-x+modetbl[i].y-y+
                   modetbl[i].color-colors)))
         {
         err=try;
         mode=modetbl[i].mode;
         if (err==0) break; /* exact match */
         }
      }
    }
  return mode;
  }
