
/*
    config.c

    This module prompts for the printer type and resolution, then
    copies the appropriate adjusted dither matrix into the global
    dvparms structure.

    Copyright (C) 1993  M. K. Fleming  All Rights Reserved.
*/

#include <stdio.h>
#include <stdlib.h>
#include <mem.h>
#include "prntpcx.h"

DEVPARM dvParms;

/*
    The tables below contain adjusted dither matrices for the 
    different printers and resolutions. Here are the calculations
    for the 150 dpi color matrix:

    1. The process we are replacing is
           RGB = input
           RGB1 = ToneAdjust(RGB)
           CMY = 255 - RGB1
           CMY1 = (DitherLevels/256) * CMY
           if (CMY1>DitherValue) set output bit.
       Note that the test CMY1>value is equivalent (255-CMY1)<=value.

    2. The raw matrix contains 8 cells, numbered 0 to 7. Renumber
       the cells to distribute the values over the interval [0-255]:
               15, 48, 80, 112, 143, 175, 207, 239
       The process now looks like this:
           if (ToneAdjust(RGB) <= value) set output bit.

    3. This can be further reduced to
           if (RGB <= inverse ToneAdjust(RGB)) set output bit
       since the tone adjustment curve is a monotone increasing
       function. To compute the final adjusted dither matrix,
       replace each Vij from step 2 with the RGB level L such that
           ToneAdjust(L) = Vij
       The new numbers are
               3, 12, 28, 50, 78, 113, 154, 201	
       (The numeric values for the tone adjustment curves are tabulated
       in the separate file TONEADJ.TXT)
*/
static DEVPARM table[] =
{
                    /* LASERJET */
1,150,150,6,6,  {  114, 100, 106, 122, 138, 130,
                    95,  31,  54, 146, 231, 207,
                    90,  82,  69, 157, 170, 187,
                   122, 138, 130, 114, 100, 106,
                   146, 231, 207,  95,  31,  54,
                   157, 170, 187,  90,  82,  69,            },

1,300,300,8,8,  {  120, 130, 126, 110,  97,  90,  93, 107,
                   180, 195, 208, 139,  63,  53,  45,  85,
                   173, 239, 222, 135,  70,  25,  35,  88,
                   148, 167, 155, 117,  83,  75,  79, 101,
                    97,  90,  93, 107, 120, 130, 126, 110,
                    63,  53,  45,  85, 180, 195, 208, 139,
                    70,  25,  35,  88, 173, 239, 222, 135,
                    83,  75,  79, 101, 148, 167, 155, 117,  },

1,600,600,8,8,  {  102, 112, 107,  92,  79,  72,  75,  88,
                   167, 184, 198, 122,  46,  38,  30,  67,
                   158, 236, 215, 117,  53,  15,  23,  70,
                   131, 152, 138,  98,  65,  57,  61,  82,
                    79,  72,  75,  88, 102, 112, 107,  92,
                    46,  38,  30,  67, 167, 184, 198, 122,
                    53,  15,  23,  70, 158, 236, 215, 117,
                    65,  57,  61,  82, 131, 152, 138,  98,  },

                    /* DESKJET - MONO */
1,150,150,6,6,  {   98,  83,  90, 107, 126, 116,
                    77,   4,  19, 138, 229, 203,
                    70,  59,  47, 149, 163, 181,
                   107, 126, 116,  98,  83,  90,
                   138, 229, 203,  77,   4,  19,
                   149, 163, 181,  70,  59,  47,            },

1,300,300,8,8,  {  102, 112, 107,  92,  79,  72,  75,  88,
                   167, 184, 199, 122,  46,  38,  30,  67,
                   158, 235, 215, 117,  53,  15,  23,  70,
                   131, 151, 139,  98,  65,  57,  61,  82,
                    79,  72,  75,  88, 102, 112, 107,  92,
                    46,  38,  30,  67, 167, 184, 199, 122,
                    53,  15,  23,  70, 158, 235, 215, 117,
                    65,  57,  61,  82, 131, 151, 139,  98,  },

                    /* DESKJET-COLOR */
3,150,150,4,4,  {  113,  50,  78,  28,
                     3, 201,  12, 154,
                    78,  28, 113,  50,
                    12, 154,   3, 201,                      },

3,300,300,8,8,  {   36,   5, 103,  30,  43,   7,  90,  25,
                     1, 116,   0, 243,   2, 130,   0, 221,
                    69,  16,  51,  10,  79,  20,  59,  13,
                     0, 181,   3, 146,   0, 200,   4, 163,
                    43,   7,  90,  25,  36,   5, 103,  30,
                     2, 130,   0, 221,   1, 116,   0, 243,
                    79,  20,  59,  13,  69,  16,  51,  10,
                     0, 200,   4, 163,   0, 181,   3, 146,  },
};

static int ibase[] = { 0, 3, 5 };


/* --------------------------------------------------------------- */
            void SelectPrinter(void)
/* --------------------------------------------------------------- */
{
char s[80];
static int ibase[] =  { 0, 3, 5, 5 };
static int maxres[] = { 3, 2, 2, 2 };
int iprint, ires, i;

    for (;;)
    {
        printf("\nSelect a printer:\n");
        printf("  1 LaserJet\n");
        printf("  2 DeskJet\n");
        printf("  3 DeskJet 500C\n");
        printf("  4 DeskJet 550C\n");
        printf("Your Choice ==> ");
        gets(s);
        iprint = atoi(s);
        if (iprint>=1 && iprint<=4) break;
        printf("** BAD INPUT -- RETRY **\n");
    }

    for (;;)
    {
        printf("\nWhat resolution:\n");
        printf("  1 150 dpi\n");
        printf("  2 300 dpi\n");
        printf("  3 600 dpi (LaserJet 4 only)\n");
        printf("Your Choice ==> ");
        gets(s);
        ires = atoi(s);
        if (ires>=1 && ires<=maxres[iprint-1]) break;
        printf("** BAD INPUT -- RETRY **\n");
    }
    printf("\n");

    i = ibase[iprint-1] + ires-1;
    movmem (table+i, &dvParms, sizeof(dvParms) );
    if (iprint==4) dvPlanes=4;
}
