
/*
    dither.c
    
    dither converts 256 levels of RGB to 2 levels of CMY. Then, 
    if necessary, it separates out a fourth black plane.
    (If dplanes=1 it converts 256 levels of gray to monochrome).

    Copyright (C) 1993  M. K. Fleming  All Rights Reserved.
*/

#include <stdio.h>
#include "prntpcx.h"

static int dbits, dbytes, dplanes, tplanes;
static unsigned char dtail;
static unsigned char *thisdtRow, *lastdtRow;

extern DEVPARM dvParms;


/* ------------------------------------------------------------ */
        int DitherInit(int width, int planes )
/* Dither initialization                                        */
/*     width = output image width (pixels)                      */
/*     planes = number of output planes (1=grayscale,           */
/*        3=CMY, or 4=CMYK)                                     */
/* Returns # bytes storage req'd for output row                 */
/* ------------------------------------------------------------ */
{
    dbits=width;  tplanes=planes;

    /* dither max of 3 planes */
    dplanes= (planes>3) ? 3 : planes;

    /* line width in even bytes */
    dbytes = (width+7)/8;

    /* mask to clear odd bits in final byte */
    dtail = 0xff << (8*dbytes - width);

    /* which row in the dither table? */
    thisdtRow=lastdtRow= DitherTable + dtRows*dtCols;

    return (dbytes * tplanes);
}


/* ------------------------------------------------------------- */
void Dither(unsigned char *src, unsigned char *dst)
/* Dithers a row from src to dst                                 */
/* ------------------------------------------------------------- */
{
int i, j, l;
unsigned char mask, val, *cut, *C, *M, *Y, *K;

    /* cut points to next row in the dither table */
    thisdtRow += dtCols;
    if (thisdtRow>=lastdtRow) thisdtRow=DitherTable;
    cut = thisdtRow;

    /* If there are 4 planes, black is first */
    if (tplanes > dplanes) { K=dst;  dst=C=K+dbytes; }
    else K=C=dst;
    M=C+dbytes; Y=M+dbytes;

    for (i=0; i<dplanes; i++)
    {
        for (j=l=val=0, mask=0x80; ; mask>>=1, l++)
        {
            /* End of dither table columns? */
            if (l==dtCols) l=0;

            /* Time to store a byte? */
            if (!mask)
            {
                mask=0x80; *dst++=val; val=0;
                if (++j==dbytes) break;
            }

            /* If picture value <= dither table, set the bit */
            if (*src++ <= cut[l]) val |= mask;
        }

        /* mask odd bits of the last byte */
        *(dst-1) &= dtail;
    }

    /* Create black plane if needed */
    if (tplanes > dplanes)
    {
        for (j=0; j<dbytes; j++, C++, M++, Y++, K++)
        {
            *K = val = (*C & *M & *Y);
            *C ^= val;
            *M ^= val;
            *Y ^= val;
        }
    }
}
