
/*
    main.c

    This is the main PCX print program. It has one required and
    three optional command line parameters:

    pcxprnt [/Wwidth] [/Hheight] filename [where]

    width    is the desired picture width in inches. The default is
             4 inches.

    height   is the picture height. If you don't specify a height,
             the program will compute it to preserve the shape of
             the picture.

    filename is the PCX file to print (with path and extension).
             It must be either a 256-color or 24-bit PCX file.
             (With suitable modifications to pcxio.c the program
             can handle other types of PCX files -- or other
             formats altogether.)

    where    is where the output goes. The default is LPT1. You
             can also use LPT2 or a disk file name.


    Copyright (C) 1993  M. K. Fleming  All Rights Reserved.
*/

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include "prntpcx.h"


/* ------------------------------------------------------------ */
                void PgmAbort(char *msg)
/* Global error handler */
/* ------------------------------------------------------------ */
{
    printf("\n%s\n",msg);
    exit(1);
}


/* ------------------------------------------------------------ */
/*          main for prntpcx                                    */
/* ------------------------------------------------------------ */
void main (int argc, char *argv[])
{
static char *usage=
    "Usage:  prntpcx [/Wwidth] [/Hheight] inFile [outFile]\n\n"
    "        width and height are in inches\n"
    "        outFile is LPT1, LPT2, or file name (default LPT1)";
static float winch=4, hinch=0;
static char *outFile="LPT1";
char *p;

    /* parse width/height options */
    while (argc>1 && (*argv[1]=='/' || *argv[1]=='-'))
    {
        p=*++argv; argc--;
        p++;
        switch (toupper(*p++))
        {
        case 'W': winch = atof(p); break;
        case 'H': hinch = atof(p); break;
        }
    }

    if (argc<2) PgmAbort(usage);
    if (argc>2) outFile=argv[2];
    SelectPrinter();
    PrintPCX (argv[1], outFile, winch, hinch );
}
