
/*
    pcxio.c

    pcxio handles all input from the PCX file. PCXopen opens the
    file, reads the header, and returns a pointer to an IMHEAD
    structure allocated on the heap. PCXread reads the next raster
    row. PCXclose closes the file and releases memory allocated
    for the header.

    Copyright (C) 1993  M. K. Fleming  All Rights Reserved.
*/

#include <stdio.h>
#include <stdlib.h>
#include <mem.h>
#include "prntpcx.h"

/* -------------------------------------------------------- */
IMHEAD *PCXopen(char *filename)
/* -------------------------------------------------------- */
{
FILE *fp;
IMHEAD *pcx;
long here;
int c;

    fp=fopen(filename,"rb");
    if (!fp) PgmAbort("File not found");

    /* allocate memory */
    pcx= (IMHEAD *)malloc(sizeof(IMHEAD));
    if (!pcx) PgmAbort("Out of memory");

    /* read the header */
    if (fread (&pcx->hd, 1, sizeof(PCXHEAD), fp) != sizeof(PCXHEAD) )
        PgmAbort("File read error");

    /* is it a PCX file? */
    if (pcx->hd.Mfg != 0x0a) PgmAbort ("Not a PCX file");

    /* initialiaze the extended palette */
    movmem(pcx->hd.palette, pcx->RGBpal, sizeof(pcx->hd.palette) );

    /* if there's a 256-color palette on the end, read it */
    if (pcx->hd.Vsn==5)
    {
        here = ftell(fp);  /* save file posn */
        if (fseek(fp, -769L, SEEK_END) == 0)
        {
            c = fgetc(fp);
            if (c < 0) PgmAbort("File read error");
            if (c == 0x0c)  /* read the palette */
            {
                if (fread(pcx->RGBpal,1,768,fp) != 768)
                    PgmAbort("File read error");
            }
        }
        fseek( fp, here, SEEK_SET);  /* back to image data */
    }
    pcx->fp=fp;
    pcx->BytesPerPlane = pcx->hd.BytesPerLine * pcx->hd.Nplanes;
    return (pcx);
}

/* -------------------------------------------------------- */
void PCXclose(IMHEAD *pcx)
/* -------------------------------------------------------- */
{
    fclose(pcx->fp);
    free(pcx);
}

/* -------------------------------------------------------- */
void PCXread(IMHEAD *pcx, unsigned char *dst)
/* Read the next PCX plane                                  */
/* -------------------------------------------------------- */
{
int n, c, runCount, bytes;
FILE *fp;

    fp=pcx->fp;  bytes=pcx->BytesPerPlane;
    for (n=0; n<bytes; )
    {
        c=fgetc(fp);
        if (c<0) PgmAbort("File read error");

        if ((c & 0xc0) != 0xc0) runCount=1;
        else
        {
            runCount = c & 0x3f;
            c=fgetc(fp);
            if (c<0) PgmAbort("File read error");
        }
        while(runCount--) dst[n++]=c;
    }
}
