
/*
    prntpcx.c

    This is the workhorse routine, that actually prints the picture.
    It processes the PCX file one line at a time. Each line is 
    read (pcxio.c), re-organized (sort.c), scaled (scale.c), 
    dithered (dither.c), and printed (pclio.c), then discarded to
    make room in memory for the next line. Each of the five sub-
    modules contains an initialization routine (called once
    at the beginning to set up static variables) and a processing
    routine (called for each input line).

    Copyright (C) 1993  M. K. Fleming  All Rights Reserved.
*/

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include "prntpcx.h"


extern DEVPARM dvParms;


/* ---------------------------------------------------------------- */
void PrintPCX (char *inFile, char *outFile, float winch, float hinch )
/* ---------------------------------------------------------------- */
{
int i, j, n=1, dFmt, y;
int inHt, inWid, inFmt, outWid, outHt;
unsigned char *b0=0, *b1, *b2, *b3;
long size, b0Size, b1Size, b2Size, b3Size;
IMHEAD *pcx;
FILE *fp;

    pcx=PCXopen(inFile);
    inWid = pcx->hd.xmax - pcx->hd.xmin + 1;
    inHt = pcx->hd.ymax - pcx->hd.ymin + 1;
    if (inWid<=0 || inHt<=0) PgmAbort("Input image size error");

    /* calculate output size in pixels */
    if (winch<=0) winch=4;
    if (hinch<=0) hinch = (winch * inHt)/inWid;
    outWid = winch*xres + 0.5;
    outHt  = hinch*yres + 0.5;

    /* Allocate Memory */
    b0Size = pcx->hd.BytesPerLine * pcx->hd.Nplanes;
    b1Size = SortInit(pcx, dvPlanes);
    b2Size = ScaleInit(inWid,inHt,outWid,outHt,dvPlanes);
    b3Size = DitherInit(outWid, dvPlanes );
    size = b0Size+b1Size+b2Size+b3Size;
    if (size<=65000l) b0 = (unsigned char *)malloc(size);
    if (!b0) PgmAbort("Insufficient memory");
    b1 = b0+b0Size;
    b2 = b1+b1Size;
    b3 = b2+b2Size;

    /* Display Picture Info */
    printf("File: %s\n", inFile);
    printf("Input  is %dx%d, %d planes, %d bits/pixel\n",
        inWid, inHt, pcx->hd.Nplanes, pcx->hd.BitsPerPix);
    printf("Output is %.1fx%.1f inches (%dx%d pixels)\n",
        winch, hinch, outWid, outHt);
    printf("Magnification = %.2fX, %.2fX\n",
        (1.0*outWid)/inWid, (1.0*outHt)/inHt );
    printf("Memory req'd = %d bytes\n\n",size);

    y=0;
    printf("Printing line %4d of %4d\b\b\b\b\b\b\b\b",
        y,outHt);
    PrintInit(outFile, outWid);
    for (j=0; j<inHt; j++)
    {
        /* Read next line */
        PCXread(pcx,b0);

        /* Re-order to RRRRRR...GGGGGG...BBBBBB... */
        /* (or convert to gray levels for a mono device) */
        SortPlanes(b0,b1);

        n=Scale(b1,b2);
        for (i=0; i<n; i++)
        {
            Dither(b2,b3);
            PrintLine(b3);
            y++;
            if (y==outHt || (y & 15)==0) printf("\b\b\b\b%4d",y);
        }
    }
    PrintClose();
    printf("\n");

    fclose(fp);
    free(pcx);
    free(b0);
}
