
/* 
    prntpcx.h 
    Copyright (C) 1993  M. K. Fleming  All Rights Reserved.
*/

/* Standard PCX header */
typedef struct
{
    char Mfg;
    char Vsn;
    char Encoding;
    char BitsPerPix;
    int  xmin,ymin;
    int  xmax,ymax;
    int  hres;
    int  vres;
    unsigned char palette[48];
    char reserved;
    char Nplanes;
    int  BytesPerLine;
    int  PalType;
    unsigned char filler[58];
} PCXHEAD;


/* header plus extra info */
typedef struct
{
    PCXHEAD hd;                      /* PCX header */
    FILE *fp;                        /* file stream pointer */
    int BytesPerPlane;               /* Byte/line * no of planes */
    unsigned char RGBpal[3*256];     /* 245-color palette */
} IMHEAD;


/* output device info */
typedef struct
{
    int _dvPlanes;                   /* 1=mono, 3=CMY, 4=CMYK */
    int _xres, _yres;                /* resolution in dpi */ 
    int _dtCols, _dtRows;            /* dither matrix dimensions */
    unsigned char _DitherTable[64];  /* the dither matrix */
} DEVPARM;

#define dvPlanes    dvParms._dvPlanes
#define dtCols      dvParms._dtCols
#define dtRows      dvParms._dtRows
#define xres        dvParms._xres
#define yres        dvParms._yres
#define DitherTable dvParms._DitherTable

/* main.c */
void PgmAbort ( char *msg );

/* config.c */
void SelectPrinter(void);

/* prntpcx.c */
void PrintPCX (char *inFile, char *outFile, float winch, float hinch );

/* dither.c */
int DitherInit ( int width , int planes );
void Dither ( unsigned char *src , unsigned char *dst );

/* scale.c */
int ScaleInit ( int ws , int hs , int wd , int hd , int dpl );
int Scale ( unsigned char *src , unsigned char *dst );

/* sort.c */
int SortInit(IMHEAD *pcx, int outPlanes);
void SortPlanes ( unsigned char *src , unsigned char *dst );

/* pcxio.c */
IMHEAD *PCXopen ( char *filename );
void PCXclose ( IMHEAD *pcx );
void PCXread ( IMHEAD *pcx , unsigned char *dst );

/* pclio.c */
void Send ( unsigned char *b , int len );
void PrintInit(char *filename, int outWidth);
void PrintClose ( void );
void PrintLine ( unsigned char *b );
