// GCD2.C
//	Iterative implementation of Euclid's algorithm for the
//	greatest common denominator.
// Copyright (C) 1993 by Nicholas Wilt.  All rights reserved.

unsigned int
gcd(unsigned int a, unsigned int b)
{
    if (a < b) {
	unsigned int temp = a; a = b; b = temp;
    }
    while (b) {
	unsigned int mod = a % b;
	b = a;
	a = mod;
    }
    return a;
}

