; gcda.asm
; Iterative implementation of Euclid's algorithm for the greatest
;	common denominator.
;
; C-callable GCD routine takes 16-bit ints a and b,
; returns GCD in AX.
;	int gcd(int a, int b);
;
; Copyright (C) 1993 by Nicholas Wilt.  All rights reserved.

.MODEL SMALL,C

.CODE

	PUBLIC	gcd

gcd	PROC	A:WORD,B:WORD
	mov	ax,A		; Get parameters
	mov	cx,B		;
	cmp	ax,cx		; Exchange so a > b
	ja	@@1		;
	xchg	ax,cx		;
@@1:	jcxz	@@Done		; Return if b == 0
	xor	dx,dx		; Zero-extend AX through DX
	div	cx		; DX <- a % b (AX trashed)
	mov	ax,cx		; a = b
	mov	cx,dx		; b = (old) a % b
	jmp	short @@1	; Loop until done
@@Done: ret			; Return a in AX
gcd	ENDP

	END
