/*******************************************************************
*                              LABELCHK.C
*    LABELCHK requests the diskette with the designated label be
* placed in the designated drive.  It reads the volume label on the
* diskette in that drive.  If the volume label matches, the program
* terminates with no further output.  If it doesn't match, LABELCHK
* displays the volume label it has just read and again asks that the
* designated volume be placed in the drive.
*     call with: labelchk <d>:<label>
*        where <label> is the volume label expected on the diskette
*        in drive <d>.  <d> must be A or B (upper or lower case).
*
*                   Written by M. L. Lesser, 5/2/93
* Compiled with IBM C/C++ Tools v2.0, and linked to VLABEL, 10/6/93
*******************************************************************/

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

char *vlabel(long DriveNumber);
char DriveCode, label[12], target[12];
int  i;
long DriveNumber;

void main(int argc, char *argv[])
{
  if ((argc == 1) || (strlen(argv[1]) > 13) || (argv[1][1] != ':'))
    {
        puts("\nError in command-line call - Terminating program");
        exit(1);
    }
    DriveCode = toupper(argv[1][0]);
    for (i = 0; i < 12; i++)
        target[i] = toupper(argv[1][i+2]);
    DriveNumber = (long)DriveCode - 64;
    if ((DriveNumber < 1) || (DriveNumber > 2))  {
        puts("Requested drive must be A or B--Terminating program");
        exit(1);
    }
again:
    printf("\n\tInsert disk with volume label \"%s\" in drive %c\n",
                target,DriveCode);
    puts("\t\tPress \"ENTER\" when ready");
    while (getchar() != '\n');    /* Wait for "Enter" key press */
    strcpy(label,vlabel(DriveNumber));
    if (strcmp(target,label) != 0)  {
    printf("The volume label on drive %c is \"%s\" -- Try again\n",
            DriveCode,label);
         goto again;
    }
    exit(0);
}
