{ Listing 2
MEM.PAS

Implements processor-dependant memory functions through the use
of custom DLL's.  This unit can be used in either Windows or DPMI
apps. Windows 3.0 Real mode is NOT supported.

Procedures and Functions:
** All functions are 32 bit on 386/486, 16 bit on 286 processors **

FastMove(var Source, Dest; Count : Word);
  Replaces the standard Move routine in the system unit.  No
  allowances are made for overlapping memory blocks.

FastFill(var Source; Count : Word; C : Byte);
  Direct replacement for the FillChar procedure in the System Unit.
}

{$IFDEF WINDOWS}  { For Windows 3.1 }
  {$A+,B-,D+,F+,G+,I-,K+,L+,N-,P-,Q-,R-,S-,T-,V+,W-,X+,Y+}
  {$M 8192,8192}
{$ELSE}           { For DPMI }
  {$A+,B-,D+,E+,F+,G+,I-,L+,N-,P-,Q-,R-,S-,T-,V+,X+,Y+}
  {$M 16384,0}
{$ENDIF}
unit Mem;

interface

type
  TFastMove  = procedure(var Source, Dest; Count : Word);
  TFastFill  = procedure(var Source; Count : Word; C : Byte);

var
  FastMove  : TFastMove;
  FastFill  : TFastFill;
  MemError   : Boolean;


implementation

uses WinApi;

{$I MEMCONST.INC}

var
  Handle   : THandle;
  OldExit  : Pointer;

procedure ExitMem;
begin
  ExitProc := OldExit;
  FreeLibrary(Handle);
end;

Begin
  OldExit  := ExitProc;           { Save for later use }
  MemError := False;              { No Error }

  { Load DLL based upon current processor }

  if (GetWinFlags and wf_CPU286) <> 0 then
      Handle := LoadLibrary('MEM286.DLL')
  else
      Handle := LoadLibrary('MEM386.DLL');

  { Make sure the DLL is loaded }

  if Handle < 32 then             { Error - DLL not Loaded }
  begin
     MemError := True;
     Exit;                        { Stop Here }
  end;

  { Get Addresses of All Functions }
  @FastMove  :=  GetProcAddress(Handle, Pchar(pr_FastMove));
  if @FastMove = nil then
     MemError := True;

  @FastFill  :=  GetProcAddress(Handle, PChar(pr_FastFill));
  if @FastFill = nil then
     MemError := True;

  ExitProc := @ExitMem;              { Install Exit procedure }
end.
