{$A+,B-,D+,F+,G+,I-,K+,L+,N-,P-,Q-,R-,S-,T-,V+,W-,X+,Y+}
{$M 8192,8192}
{
  Listing 3
  MEM286.PAS
  Implements the 16 bit (80286) version of the library.
  For binary compatability, compile for a Windows target
  (BPC -CW MEM286.PAS or Compile | Target | Windows in the IDE)
}


library Mem286;

procedure FastMove(Source, Dest : Pointer; Count : Word); export;
begin
  asm
    CLD                          { Forward }
    LDS  SI,  Source             { Load Source address }
    LES  DI,  Dest               { Load Destination Address }
    MOV  CX,  Count              { Get Count }

    SHR  CX, 1                   { Convert byte to words }
    REP  MOVSW                   { Move them }
    ADC  CX, CX                  { CX->CX+Carry }
    REP MOVSB                    { Move odd byte, if it exists }
  end;
end;

procedure FastFill(var Source; Count : Word; C : Byte); export;
begin
  asm
     CLD                         { Forward }
     MOV AH, C                   { Get byte }
     MOV AL, AH                  { Copy to AH for full word }
     MOV CX, Count               { Get count }
     LES DI, Source              { Get Address to ES:DI }

     SHR CX, 1                   { Convert to words }
     REP STOSW                   { Store a word at a time }
     ADC CX, CX                  { Add carry }
     REP STOSB                   { Finish, if necessary }
  end;
end;


{$I MEMCONST.INC}

exports
  FastMove  Index pr_FastMove,
  FastFill  Index pr_FastFill;

begin
end.
