//Listing 2 -- STATE.CPP:

#include <stdlib.h>    // for abs()
#include <assert.h>    // for assert()
#include "state.h"

// -------------------------------------------------------------
TPolygon::TPolygon(int nVertices_, TPoint *pVertices_)
         :nVertices(nVertices_)
{
    pVertices = new TPoint[nVertices];
    for(int i=0; i<nVertices; i++)
        pVertices[i] = pVertices_[i];

    CheckState();
}

TPolygon::~TPolygon()
{
    delete [] pVertices;
}

//
//  The public member function to translate the polygon.
//
void TPolygon::Translate(TPoint point)
{
    // Do the real work.
    prvTranslate(point);

    // Make sure we're still valid.
    CheckState();
}

//
//  The protected member function to translate the polygon.
//
void TPolygon::prvTranslate(TPoint point)
{
    for(int i=0; i<nVertices; i++)
        pVertices[i] += point;

    // Note -- no call to CheckState() because we're not public.
}

//
//  Flip the polygon vertically over the horizontal line
//  through its 0th vertex.
//
void TPolygon::VFlip()
{
    // Translate the 0th vertex to the origin.
    TPoint pt0 = pVertices[0];
    prvTranslate(-pt0);

    // Flip all the y coordinates.
    for(int i=1; i<nVertices; i++)
        pVertices[i].y = -pVertices[i].y;

    // Put the shape back where it came from.
    prvTranslate(pt0);

    // Make sure we're still valid.
    CheckState();
}

#ifndef NDEBUG
void TPolygon::CheckState() const
{
    // We have to have at least three vertices.
    assert(nVertices > 2);

    // The pointer to our vertices can't be NULL.
    assert(pVertices);
}
#endif // #ifndef NDEBUG

// -------------------------------------------------------------
TRectangle::TRectangle(TPoint *pVertices_)
           :TPolygon(4, pVertices_)
{
    uArea = prvCalcArea();

    CheckState();
}

//
//  The protected member function for calculating our area.
//  Note that we DON'T call CheckState().
//
unsigned TRectangle::prvCalcArea() const
{
   unsigned uWidth, uHeight;

    if(pVertices[0].x == pVertices[1].x) {
        uWidth  = abs(pVertices[0].x - pVertices[3].x);
        uHeight = abs(pVertices[0].y - pVertices[1].y);
    } else {
        uWidth  = abs(pVertices[0].x - pVertices[1].x);
        uHeight = abs(pVertices[0].y - pVertices[3].y);
    }

    return uWidth * uHeight;
}

#ifndef NDEBUG
void TRectangle::CheckState() const
{
    TPolygon::CheckState();

    // We have 4 vertices...
    assert(nVertices == 4);

    // ... and two horizontal and two vertical edges.
    if(pVertices[0].x == pVertices[1].x) {
        assert(pVertices[2].x == pVertices[3].x);
        assert(pVertices[0].y == pVertices[3].y);
        assert(pVertices[1].y == pVertices[2].y);
    } else {
        assert(pVertices[0].x == pVertices[3].x);
        assert(pVertices[1].x == pVertices[2].x);
        assert(pVertices[0].y == pVertices[1].y);
        assert(pVertices[2].y == pVertices[3].y);
    }

    // Insure that our uArea member is correct.
    assert(uArea == prvCalcArea());
}
#endif // #ifndef NDEBUG

