// Listing 3
//---------------------------------------------------------------
//
// VDRV.CPP
// Author: Brian Hook
//
// Loadable video driver class.  This code was compiled under
// Borland C++ 3.1 in the large memory model.
//---------------------------------------------------------------
#include <alloc.h>
#include <dos.h>
#include <io.h>
#include <stdio.h>
#include <string.h>
#include "vdrv.h"

VDRV::VDRV( const char *fname )
{
   driver_memory_start = NULL;
   driver_code_address = NULL;
   vdh                 = NULL;
   vdi                 = NULL;

   Load( fname );
}

VDRV::~VDRV()
{
   if ( driver_memory_start != NULL )
      farfree( driver_memory_start );
}

//---------------------------------------------------------------
// BOOLEAN VDRV::Load( const char *fname )
//
// Main routine used by the driver to allocate memory, load the
// code into the allocated memory, and then assign pointers to
// functions and structures.
//---------------------------------------------------------------
BOOLEAN VDRV::Load( const char *filename )
{
unsigned s;             // segment
long     filesize;
FILE *   fp;

   if ( filename == NULL ) {
      error = VDRV_FILE_NOT_FOUND;
      return FALSE;
   }

   if ( ( fp = fopen( filename, "rb" ) ) == NULL ) {
      error = VDRV_FILE_NOT_FOUND;
      return FALSE;
   }

   //--- Loaded code cannot be greater than a real-mode segment,
   //--- or approximately 64K.
   filesize = filelength( fileno( fp ) );
   if ( filesize >= VDRV_MAX_SIZE ) {
      fclose( fp );
      error = VDRV_TOO_BIG;
      return FALSE;
   }

   //--- Allocate a bit more memory than necessary for padding ----
   //--- We MUST use farmalloc() since the driver must reside in --
   //--- its own segment.
   driver_memory_start = farmalloc( filesize + 0x10L );
   if ( driver_memory_start == NULL ) {
      fclose( fp );
      error = VDRV_OUT_OF_MEM;
      return FALSE;
   }

   //--- Load driver into next available segment boundary ------
   driver_code_address = MK_FP( FP_SEG( driver_memory_start )+1,0);
   s                   = FP_SEG( driver_code_address );

   //--- Read in the file --------------------------------------
   //--- WARNING: fread() expects to take a near pointer in the
   //--- data models, so you must use _dos_read, which always
   //--- takes a far pointer, in small data models.
   fread( ( void far * ) driver_code_address, filesize, 1, fp );

   //--- Assign pointers ---------------------------------------
   vdh = ( VDRV_HEADER far * ) driver_code_address;
   vdi = ( VDRV_INFO far * ) ( ( unsigned long ) vdh +
         sizeof( VDRV_HEADER ) );
   mode_list = ( MODE_DEF * ) ( ( unsigned long ) vdi +
         sizeof ( VDRV_INFO ) );

   //--- Make sure we're loading a valid driver ----------------
   if ( vdi->magic_cookie != VDRV_MAGIC ) {
      farfree( driver_memory_start );
      error = VDRV_BAD_MAGIC;
      return FALSE;
   }

   //--- Construct function pointers ------------------------
   InitDriver=(int(far*)(int))MK_FP( s, vdh->InitDriver );
   EndDriver=(void(far*)())MK_FP( s, vdh->EndDriver );
   StartGraphics=(void(far*)(int))MK_FP( s, vdh->StartGraphics );
   EndGraphics=(void(far*)())MK_FP( s, vdh->EndGraphics );
   Point=(void(far*)(int,int,COLOR))MK_FP( s, vdh->Point );

   error = VDRV_OK;
   return TRUE;
}

