// Listing 1
#ifndef __VDRV_H
#define __VDRV_H

//--- Boolean type definition ------------------------------------
enum BOOLEAN { FALSE, TRUE };

//--- COLOR definition -------------------------------------------
typedef unsigned char COLOR;

//--- Manifest constants -----------------------------------------
#define VDRV_MAX_SIZE  64000
#define VDRV_MAGIC     0x32607L

//--- Error values returned by the VDRV constructor --------------
#define VDRV_OK              0x0000
#define VDRV_FILE_NOT_FOUND  0x0001
#define VDRV_TOO_BIG         0x0002
#define VDRV_BAD_MAGIC       0x0003
#define VDRV_OUT_OF_MEM      0x0004

// Error codes returned by VDRV::InitDriver() --------------------
// In a more thorough example, it could return an error code
// signifying that the device is not installed or not responding
// to software commands.
#define VINIT_OK             0x0000

// MODE_DEF structure --------------------------------------------
// This is overkill for this article, however something like
// this should be used when loading a driver that supports
// different modes of operation.  For example, a single video
// driver could support multiple resolutions and color depths.
typedef struct {
   int      number;
   unsigned width, height;
   unsigned color_depth;
   unsigned pages;
} MODE_DEF;

// VDRV_STATUS structure -----------------------------------------
// Some type of structure should be implemented that returns
// information about the specific driver.  In this case, we
// are looking for a "magic cookie" to let us know we have
// loaded a valid driver.
typedef struct {
   unsigned long magic_cookie;
} VDRV_INFO;

// VDRV_HEADER structure -----------------------------------------
// This is the core structure used for loading a driver.  Since
// the is being loaded in "raw", we don't know where individual
// routines begin.  This structure gives us the offsets from 0
// where the driver functions can be found.  Obviously this is a
// pretty stripped down version, but it would be trivial to expand.
typedef struct {

   unsigned InitDriver;
   unsigned EndDriver;
   unsigned StartGraphics;
   unsigned EndGraphics;

   unsigned Point;

} VDRV_HEADER;

//--- Actual VDRV class definition --------------------------------
class VDRV
{
   protected:

      //--- Non-segment aligned pointer
      void far *driver_memory_start;
      //--- Segment aligned pointer
      void far *driver_code_address;

      //--- Error code
      int       error;

   public:
      const VDRV_HEADER far *vdh;
      const VDRV_INFO   far *vdi;
      const MODE_DEF    far *mode_list;

      VDRV( const char *filename = 0 );
      ~VDRV();

      int  GetError( void ) { return error; }

      BOOLEAN Load( const char *filename );

      int  (far *InitDriver)( int param );
      void (far *EndDriver)( void );

      void (far *StartGraphics)( int mode );
      void (far *EndGraphics)( void );

      void (far *Point)( int x, int y, COLOR color );

};

#endif
