PROGRAM wincontrol;
  { Control of the main window under WinCrt. }

USES WinCrt, WinProcs, WinTypes, Strings;

VAR saved_cursor:  HCursor;
    i:             integer;

BEGIN
  { Set the window title.  Must do before any output. }
  StrCopy(WindowTitle,'A Sample Program');
  InitWinCrt;
  write('Press Return...'); readln;

  { Change the window title. }
  SetWindowText(GetActiveWindow,'An Example');
  write('Press Return...'); readln;

  { Maximize the window. }
  ShowWindow(GetActiveWindow,SW_SHOWMAXIMIZED);
  write('Press Return...'); readln;

  { Back to normal size. }
  ShowWindow(GetActiveWindow,SW_SHOWNORMAL);

  { Change mouse cursor to hourglass. }
  write('Wait a moment, I''m thinking...');
  saved_cursor := SetCursor(LoadCursor(0,IDC_WAIT));

  { Sleep a moment, then put cursor back to normal. }
  FOR i:=-32767 TO 32767 DO Yield;
  SetCursor(saved_cursor);
  write('Finished.  Press Return...'); readln;

  { Make the window disappear. }
  DoneWinCrt;
END.
