/*------------------------------------------------------------*/
/* INT_LOG.C - INTERRUPT LOGGING PROGRAM                      */
/* This program will note changes to the PC's                 */
/* interrupts - useful for tracking TSR incompatibilities     */
/* and just making sure that your TSR's clean up after        */
/* themselves.                                                */
/*------------------------------------------------------------*/
/* By: Steven C. Hageman - 9/11/93      Version: 1.0 9/11/93  */
/*------------------------------------------------------------*/


/*----- Includes -----*/
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


/*----- Function prototype -----*/
void read_int_from_dos(int int_num,
					   unsigned int *seg,
					   unsigned int *off);


/*----- Start of program -----*/
void main( int argc, char *argv[] )
{
/* Variables */
int int_num, chg_flg=0;
unsigned int int_seg, int_off, f_int_seg, f_int_off;
FILE *fh;

	/* Sign-on greeting */
	printf("\nINT_LOG - TSR Interrupt usage logging");
	printf("\nBy: S.C.Hageman 9/93\n");

	/* Crude command line parser (really crude!!!) */
	if( (argc > 3) || (argc < 3) )
	{
	  printf("\nIncorrect command line, proper usage:   ");
	  printf("\n  To start:               To end:       ");
	  printf("\nint_log /s fname  -or-  int_log /e fname");
	  printf("\n         ^   ^                   ^      ");
	  printf("\n         |   |                   |      ");
	  printf("\n         |   +- filename.ext     |      ");
	  printf("\n         +- start                +- end ");
	  printf("\n\n");
	  exit(1);
	}

	/* Check for start '/S' switch */
	if( stricmp(argv[1], "/S" ) == 0)
	{
        /*----- Log on -----*/
		/* Open file */
		if( (fh = fopen(argv[2], "w")) == NULL)
		{
		  printf("Can't open file for writing");
		  exit(1);
		}

		/* Loop and write each int address
                   to the disk file: */
		for( int_num = 0 ; int_num <= 0xff ; int_num++ )
		{
		  read_int_from_dos(int_num, &int_seg, &int_off);
		  fprintf( fh, "%4.4x %4.4x\n", int_seg, int_off);
		}
		/* End */
		fclose(fh);
		printf("\nINT_LOG completed start operation\n");
		exit(0);
	 }
	 else
	 { /* If here, should be '/E' switch */
 	   /*----- End log and print differences -----*/
	   /* Open file */
	   if( (fh = fopen(argv[2], "r")) == NULL)
	     {
		printf("Can't open file for reading");
		exit(1);
	     }
  	   /* Loop for each int, print if different */
	   for( int_num = 0 ; int_num <= 0xff ; int_num++ )
	     {
	       /* Read INT from DOS */
	       read_int_from_dos(int_num, &int_seg, &int_off);

	       /* Read INT from log file */
	       fscanf( fh, "%x", &f_int_seg);
	       fscanf( fh, "%x", &f_int_off);

	       /* Print if the two are different */
	       if((int_seg != f_int_seg) && (int_off != f_int_off))
		 {
		   chg_flg = 1;
		   printf("\n\t");
		printf("INT %2.2xh Changed to address %4.4x:%4.4x",
		          int_num, int_seg, int_off);
		 }
	     }
		/* End */
		fclose(fh);

		/* Say something if no changes were found */
		if( chg_flg == 0 )
			printf("\n\tNo INT changes were found");

		printf("\n\nINT_LOG completed end operation\n");
		exit(0);
	 }
}    /*----- End of main -----*/


/*----- Using DOS INT 21h, function 35h -----*/
/*----- Read and return an interupt address -*/

void read_int_from_dos(int int_num,
					   unsigned int *seg,
					   unsigned int *off)
{
unsigned int int_seg, int_off;
union REGS inregs, outregs;
struct SREGS segregs;

	inregs.h.ah = 0x35;            /* Function 35h */
	inregs.h.al = (char)int_num;   /* Int number 0-255 */

	/* Call INT 21h */
	intdosx( &inregs, &outregs, &segregs );

	/* Return INT segment and offset */
	*seg = segregs.es;
	*off = outregs.x.bx;
}

/*----- Fini: INT_LOG.C -----*/

