program DefLeppLyrics;

uses
  Objects, WinTypes, WinProcs, OWindows, ODialogs, Strings,
  SrchList, BWCC;

{$R LYRICS.RES}

const
  id_SongList = 101;
  id_Lyrics   = 102;

type

  PMainWindow = ^TMainWindow;
  TMainWindow = object( TDlgWindow )
    SongList : PListBox;

    constructor Init( AParent : PWindowsObject; AName : PChar );

    procedure SetupWindow; virtual;
    procedure HandleLyricsPB( var Msg : TMessage );
      virtual id_First + id_Lyrics;
  end;

  TLyricsApplication = object( TApplication )
    procedure InitMainWindow; virtual;
  end;


{=========================}
{== TMainWindow Methods ==}
{=========================}

constructor TMainWindow.Init( AParent : PWindowsObject;
                              AName : PChar );
begin
  inherited Init( AParent, AName );
               { Simply use PSearchableList instead of PListbox }
  SongList := New( PSearchableList,
                   InitResource( @Self, id_SongList ) );
end; {= TMainWindow.Init =}


procedure TMainWindow.SetupWindow;
begin
  inherited SetupWindow;

  SongList^.AddString( 'Action' );
  SongList^.AddString( 'Animal' );
  SongList^.AddString( 'Armageddon It' );
  SongList^.AddString( 'From The Inside' );
  SongList^.AddString( 'Foolin''' );
  SongList^.AddString( 'Hysteria' );
  SongList^.AddString( 'Stand Up (Kick Love Into Motion)' );
  SongList^.AddString( 'Too Late For Love' );
  SongList^.AddString( 'Two Steps Behind' );
  SongList^.AddString( 'Tonight' );
  SongList^.AddString( 'Tear It Down' );
  SongList^.AddString( 'Miss You In A Heartbeat' );
  SongList^.AddString( 'Personal Property' );
  SongList^.AddString( 'Pour Some Sugar On Me' );
  SongList^.AddString( 'Photograph' );
  SongList^.AddString( 'Ride Into The Sun' );
  SongList^.AddString( 'Ring Of Fire' );
  SongList^.AddString( 'Rocket' );
  SongList^.AddString( 'Run Riot' );
  SongList^.AddString( 'Rock Rock (Till You Drop)' );
  SongList^.AddString( 'Rock Of Ages' );
end; {= TMainWindow.SetupWindow =}


procedure TMainWindow.HandleLyricsPB( var Msg : TMessage );
var
  S, MsgTitle : array[ 0..80 ] of Char;
begin
  SongList^.GetSelString( S, 80 );
  StrCopy( MsgTitle, 'Lyrics to ' );
  StrCat( MsgTitle, S );
  MessageBox( HWindow, 'This is where lyrics are displayed',
              MsgTitle, mb_Ok );
end; {= TMainWindow.HandleLyricsPB =}


{================================}
{== TLyricsApplication Methods ==}
{================================}

procedure TLyricsApplication.InitMainWindow;
begin
  MainWindow := New( PMainWindow, Init( nil, 'MainWin' ) );
end;

var
  LyricsApp : TLyricsApplication;

begin {=== MAIN ===}
  LyricsApp.Init( 'LyricsApp' );
  LyricsApp.Run;
  LyricsApp.Done;
end. {=== MAIN ===}
