/* SLIDES Screen saver -- Williams */
#include <windows.h>
#include <commdlg.h>
#include <mmsystem.h>
#include "slides.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define PATHSIZE 67  // size of file name + path

/* Externals defined in SCRNSAVE.H. Required. */
char szAppName[40];
HINSTANCE hMainInstance;
HWND hMainWindow;
char szName[]="Programmer's Slide Show";
char szIsPassword[22];
char szIniFile[MAXFILELEN];
char szChangePW[30];
char szBadOldPW[BUFFLEN];
char szHelpFile[MAXFILELEN];
char szNoHelpMemory[BUFFLEN];
char szScreenSaver[22];
char szPassword[16];
char szDifferentPW[BUFFLEN];
UINT MyHelpMessage;
HOOKPROC fpMessageFilter;


char speed_str[]="Speed";
char sound_str[]="Sound";
WORD delay;              // speed parameter
WORD timer_id;           // timer id
BOOL sound_flag;         // sound on/off flag
BOOL pw;                 // password protected?



/* Screen saver callback -- must have this name */
LONG FAR PASCAL ScreenSaverProc(HWND hWnd,UINT msg,
                      WPARAM wParam,LPARAM lParam)
   {
   RECT rc;
   switch (msg)
      {
   case WM_CREATE:
      ShowCursor(FALSE);
      /* Load the strings from the STRINGTABLE */
      get_strings();

      /* Load the initial  settings. */
      read_inifile();
      PostMessage(hWnd,WM_TIMER,0,0);  // show 1st time
      break;

   case WM_TIMER:
/* Since drawing the image might take awhile, reset
   the time on each pass. */
      if (timer_id) KillTimer(hWnd,ID_TIMER);
      DrawImage(hWnd);
      timer_id=SetTimer(hWnd,ID_TIMER,delay*1000,NULL);
      break;

   case WM_DESTROY:
      /* Destroy objects */
      if (timer_id)
         KillTimer(hWnd,ID_TIMER);
      /* Turn off sound */
      if (sound_flag)
         sndPlaySound(NULL,0);
      ShowCursor(TRUE);
      break;

   default:
      break;
      }
/* default screen saver callback */
   return DefScreenSaverProc(hWnd,msg,wParam,lParam);
  }

/* Initialization required by configuration dialog */
BOOL RegisterDialogClasses(HINSTANCE hInst)
   {
/* We don't need any */
   return TRUE;
   }


/* read_inifile -- Get initial settings from WIN.INI */
static void read_inifile()
   {
   delay=GetPrivateProfileInt(szAppName,
             speed_str,DEF_SPEED,szIniFile);
   sound_flag=GetPrivateProfileInt(szAppName,sound_str,
             DEF_SOUND,szIniFile);
   pw=GetPrivateProfileInt(szAppName,
             szIsPassword,FALSE,szIniFile);
   }

/* Draw a bitmap to a DC */
void draw_bitmap(HDC dc,int x,int y,int wid,int hi,
                 HBITMAP bm)
  {
  HDC memdc;
/* Create memory DC */
  memdc=CreateCompatibleDC(dc);
/* Put bitmap in */
  SelectObject(memdc,bm);
/* BitBlt it to screen */
  BitBlt(dc,x,y,wid,hi,memdc,0,0,SRCCOPY);
  DeleteDC(memdc);
  }


/* Draw screen saver image */
static void DrawImage(HWND hWnd)
   {
   HDC hDC;              // Handle to our window DC
   RECT rcWnd;           // Client rect
   HBITMAP bm;           // bitmap
   BITMAP bitmapinfo;    // info about bitmap
   HGLOBAL hwave;        // wave resource
   void _far *wave;      // wave data
   char res_name[66];    // name of resource
   static int max=0;     // # of slides
   static int cur=0;     // current slide
/* find # of slides once */
   if (!max)
     {
     char num[33];
     LoadString(hMainInstance,idsNumberSlides,num,
                sizeof(num));
     max=atoi(num);
     }
/* Get window size */
   GetClientRect(hWnd,&rcWnd);
   hDC=GetDC(hWnd);
   PatBlt(hDC,0,0,rcWnd.right,rcWnd.bottom,BLACKNESS);
/* Find bitmap */
   wsprintf(res_name,"BITMAP%d",cur);
   bm=LoadBitmap(hMainInstance,res_name);
   if (bm)
    {
/* Center bitmap on screen */
    GetObject(bm,sizeof(BITMAP),&bitmapinfo);
    if (rcWnd.bottom>bitmapinfo.bmHeight)
     {
     rcWnd.top=(rcWnd.bottom-bitmapinfo.bmHeight)/2;
     rcWnd.bottom-=rcWnd.top;
     }
    if (rcWnd.right>bitmapinfo.bmWidth)
     {
     rcWnd.left=(rcWnd.right-bitmapinfo.bmWidth)/2;
     rcWnd.right-=rcWnd.left;
     }
// draw here
    draw_bitmap(hDC,rcWnd.left,rcWnd.top,
                bitmapinfo.bmWidth,bitmapinfo.bmHeight,bm);
    DeleteObject(bm);
    }
   ReleaseDC(hWnd,hDC);
/* Do sound processing */
   if (sound_flag)
     {
     wsprintf(res_name,"WAVE%d",cur);
     hwave=LoadResource(hMainInstance,
           FindResource(hMainInstance,res_name,"WAVEFILE"));
     if (hwave)
        wave=LockResource(hwave);
     if (wave)
        sndPlaySound(wave,SND_SYNC|SND_NODEFAULT|SND_MEMORY);
     UnlockResource(hwave);
     }
/* Increase slide number */
   if (++cur>=max) cur=0;
   }



/*  Dialog box function for configuration dialog. */
BOOL FAR PASCAL ScreenSaverConfigureDialog(HWND hDlg,
                      UINT msg,WPARAM wParam,LPARAM lParam)
   {
   static HWND idok;
   static HWND setpw;
   int helpon;
   switch (msg)
      {
   case WM_INITDIALOG:
/* Set up dialog */
      get_strings();
      read_inifile();
      SetDlgItemInt(hDlg,ID_SPEED,delay,FALSE);
      SendDlgItemMessage(hDlg,ID_SOUND,BM_SETCHECK,
                         sound_flag,NULL);
      SendDlgItemMessage(hDlg,ID_PASSWORDPROTECTED,
                         BM_SETCHECK,pw,NULL);
      setpw=GetDlgItem(hDlg,ID_SETPASSWORD);
      EnableWindow(setpw,pw);
      idok=GetDlgItem(hDlg,IDOK);
      return TRUE;

   case WM_COMMAND:
      switch (wParam)
         {
      case IDOK:
         delay=GetDlgItemInt(hDlg,ID_SPEED,NULL,FALSE);
         sound_flag=IsDlgButtonChecked(hDlg,ID_SOUND);
         pw=IsDlgButtonChecked(hDlg,ID_PASSWORDPROTECTED);
         write_iniint(szAppName,speed_str,delay);
         write_iniint(szAppName,sound_str,sound_flag);
         write_iniint(szAppName,szIsPassword,pw);
         EndDialog(hDlg,TRUE);
         return TRUE;

      case IDCANCEL:
         EndDialog(hDlg,FALSE);
         return TRUE;

      case ID_SETPASSWORD:
         {
         FARPROC fpDialog;
         if ((fpDialog=MakeProcInstance(DlgChangePassword,
                          hMainInstance)) ==
                          NULL)
            return FALSE;
         DialogBox(hMainInstance,
            MAKEINTRESOURCE(DLG_CHANGEPASSWORD),hDlg,
            fpDialog);
         FreeProcInstance(fpDialog);
         SendMessage(hDlg,WM_NEXTDLGCTL,idok,1);
         break;
         }

      case ID_PASSWORDPROTECTED:
         pw^=1;
         CheckDlgButton(hDlg,wParam,pw);
         EnableWindow(setpw,pw);
         break;

      case ID_ABOUT:
           MessageBox(hDlg,
           "Programmer's Slide Show Screen Saver\n"
           "By Al Williams","About",
            MB_OK|MB_ICONINFORMATION);
           break;

      case ID_HELP:
         helper:
/* Use this line if you have custom help.... */
//           helpon=WinHelp(hDlg,szHelpFile,
//                     HELP_CONTEXT,IDH_DLG_SLIDES);
/* Otherwise, use this one.... */
           helpon=WinHelp(hDlg,szHelpFile,
                      HELP_CONTENTS,0);
           if (!helpon)
              MessageBox(hDlg,szNoHelpMemory,szName,MB_OK);
         break;
         }
      break;

   default:
      if (msg==MyHelpMessage) // Context sensitive help
         goto helper;
      }
   return FALSE;
   }

/* Write an unsigned int to CONTROL.INI. */
static void write_iniint(LPSTR sec,LPSTR key,int i)
   {
   char buf[40];
   /* GetPrivateProfileInt() can't do signed values! */
   wsprintf(buf,"%u",i);
   WritePrivateProfileString(sec,key,buf,szIniFile);
   }

/* Get strings from string table */
void get_strings(void)
   {
   LoadString(hMainInstance,idsIsPassword,
              szIsPassword,22);
   LoadString(hMainInstance,idsIniFile,
              szIniFile,MAXFILELEN);
   LoadString(hMainInstance,idsScreenSaver,
              szScreenSaver,22);
   LoadString(hMainInstance,idsPassword,
              szPassword,16);
   LoadString(hMainInstance,idsDifferentPW,
              szDifferentPW,BUFFLEN);
   LoadString(hMainInstance,idsChangePW,
              szChangePW,30);
   LoadString(hMainInstance,idsBadOldPW,
              szBadOldPW,255);
   LoadString(hMainInstance,idsHelpFile,
              szHelpFile,MAXFILELEN);
   LoadString(hMainInstance,idsNoHelpMemory,
              szNoHelpMemory,BUFFLEN);
  }
