unit SrchList;

interface {=== Unit SrchList ===}

uses
  WinTypes, WinProcs, OWindows, ODialogs, Strings;

type
  TString = array[ 0..255 ] of Char;

  PSearchableList = ^TSearchableList;
  TSearchableList = object( TListBox )
    SearchStr : TString;

    constructor Init( AParent : PWindowsObject; AnId : Integer;
                      X, Y, W, H : Integer );

    constructor InitResource( AParent : PWindowsObject;
                              ResId : Integer );

    procedure WMChar( var Msg : TMessage );
      virtual wm_First + wm_Char;
    procedure WMKeyDown( var Msg : TMessage );
      virtual wm_First + wm_KeyDown;
    procedure WMLButtonDown( var Msg : TMessage );
      virtual wm_First + wm_LButtonDown;
  end;


implementation {=== Unit SrchList ===}

{= StrCatCh - This function should have been included in the   =}
{= Strings Unit. It concats the char C at the end of string S. =}

function StrCatCh( S : PChar; C : Char ) : PChar;
begin
  S[ StrLen( S ) + 1 ] := #0;         { MUST Set new end First! }
  S[ StrLen( S ) ] := C;               { Next, tack on new char }
  StrCatCh := S;
end;


{=============================}
{== TSearchableList Methods ==}
{=============================}

constructor TSearchableList.Init( AParent : PWindowsObject;
                                  AnId : Integer;
                                  X, Y, W, H : Integer );
begin
  inherited Init( AParent, AnId, X, Y, W, H );
  SearchStr[ 0 ] := #0;     { Quick Way to Clear a PChar String }
end; {= TSearchableList.Init =}


constructor TSearchableList.InitResource( AParent : PWindowsObject;
                                          ResId : Integer );
begin
  inherited InitResource( AParent, ResId );
  SearchStr[ 0 ] := #0;
end; {= TSearchableList.InitResource =}


procedure TSearchableList.WMChar( var Msg : TMessage );
var
  TestStr : TString;
  C : Char;
  Len : Word;
  Idx : Integer;
begin
  C := Chr( Msg.WParam );        { Store Character User Pressed }

  if C = #3 then                   { if User presses Ctrl+C ... }
  begin
    SearchStr[ 0 ] := #0;                     { Clear SearchStr }
    SetSelIndex( 0 );               { Move Selection Bar to Top }
    Exit;
  end
  else if C = #8 then            { if User presses BACKSPACE... }
  begin
    Len := StrLen( SearchStr );
    if Len = 1 then           { if SearchStr has only 1 char... }
    begin
      SearchStr[ 0 ] := #0;                   { Clear SearchStr }
      SetSelIndex( 0 );             { Move Selection Bar to Top }
      Exit;
    end
    else if Len > 1 then    { else if SearchStr has > 1 char... }
    begin
      SearchStr[ Len - 1 ] := #0;            { Remove Last Char }
      StrCopy( TestStr, SearchStr );
    end
    else { Len = 0 }            { else if SearchStr is empty... }
    begin
      MessageBeep( mb_IconHand );                { Sound a Beep }
      Exit;
    end;
  end
  else                                  { if not a BACKSPACE... }
  begin
    StrCopy( TestStr, SearchStr );              { Setup TestStr }
    StrCatCh( TestStr, C );              { Add Newly typed char }
  end;
       { Search entire list for string that starts with TestStr }
  Idx := SetSelString( TestStr, -1 );
  if Idx <> -1 then                          { If Find Match... }
    StrCopy( SearchStr, TestStr )                { Save TestStr }
  else
    MessageBeep( mb_IconHand );               { Else Sound Beep }
end; {= TSearchableList.WMChar =}


procedure TSearchableList.WMKeyDown( var Msg : TMessage );
begin
  if ( Msg.WParam = vk_Up ) or
     ( Msg.WParam = vk_Down ) or
     ( Msg.WParam = vk_Prior ) or
     ( Msg.WParam = vk_Next ) or
     ( Msg.WParam = vk_Home ) or
     ( Msg.WParam = vk_End ) then
    SearchStr[ 0 ] := #0;  { Clear SearchStr on Position Change }
  DefWndProc( Msg );
end; {= TSearchableList.WMKeyDown =}


procedure TSearchableList.WMLButtonDown( var Msg : TMessage );
begin
  SearchStr[ 0 ] := #0;
  inherited WMLButtonDown( Msg );
end; {= TSearchableList.WMLButtonDown =}


end. {=== Unit SrchList ===}