program YieldExample;

uses
  WinCrt,   { Crt window emulation }
  WinTypes, { TMsg type }
  WinProcs, {PeekMessage, TranslateMessage, DispatchMessage, Yield,
              WaitMessage routines }
  OWindows, { Application object }
  MMSystem; { timeGetTime routine }

function SafeYield(WaitForMessage: Boolean): Boolean;
{ Yield control to other applications
  WaitForMessage paramter:
    true  - yields until a message appears in the message queue
    false - yields only once
  Returns
    true  - performed normal yield
    false - found wm_Quit message
}
var
  Msg: TMsg;
begin
  SafeYield := False;
  if PeekMessage(Msg, 0, 0, 0, pm_Remve) then begin
    if Msg.Message = wm_Quit then begin
      PostQuitMessage(Msg.wParam); { repost wm_Quit message }
      exit
    end
    else
      { if there is an Application then try to ProcessAppMsg
        if ProcessAppMsg fails or there is no Applcation,
        then Translate and Dispatch the message }
      if (Application = nil) or
        ((Application <> nil) and
        (not Application^ ProcessAppMsg(Msg)))
      then begin
        TranslateMessage(Msg);
        DispatchMessage(Msg)
      end
  end
  else
    if (Application = nil) or (not Application^.IdleAction) then
      if WaitForMessage then
        WaitMessage
      else
        Yield;
  SafeYield := True;
end; { function SafeYield }

function Delay(ms: word): word;
{ emulation of the Crt Delay routine -
 yields control until a certain amount of time
  in millisecods has passed - returns actual time waited }
var
  StartTime: longint;
begin
  StartTime := timeGetTime;
  while SafeYield(false) and (StartTime + ms > timeGetTime) do ;
  Delay := timeGetTime - StartTime;
end;

begin
  Writeln('waiting 10 seconds...');
  Writeln(Delay(10000));
end.