{ --------------------------------------------------------------
Listings -- DosBox Code: Engine & 3 Front Ends { DosBox.LST }

These materials are Copyright (c) 1993 by Gene Fowler but what's
mine may be used freely though not placed in the public domain.
----------------------------------------------------------------
Many of the demos for Turbo Vision 1 (with Turbo Pascal 6.0
Professional) and Turbo Vision 2 (With Borland Pascal with
Objects 7.0) incorporate DosShell. It's also "demo'd" by the
DOS based IDEs in these packages. The routine allows you to
shell out of the program (on top of it) and to work in a
second COMMAND.COM.

DosBox replaces DosShell and quickly-produced "feeder" procs
yield a dos shell, an internal dos command line, and wired-in
programs. TV2 requires some "fitting" that TV1 doesn't, but
copying in this code works fine in either.

In TV1, you will delete DosShell and put DosBox in its place.
But in TV2 DosShell has been dropped into EDITORS.PAS so I
replace the term DosShell with DosShellx.

In TV1, you can directly replace, change or add menu items
in the main program. In TV2, you find under File Menu only
"StdFileMenuItems" and a line that reads "nil,)),". Delete the
function call, but leave the "nil,))," there. Open App.PAS (you
get the .PAS and not an .INT even without buying the Run Time
Library). Find the function. Transfer the block BETWEEN begin
and end to where the function call was. Delete the line begin-
ning with "Next" (the last line) and pull up the "nill,)),"
line. After you have have finished rebuilding your menu, add
parentheses marks til there is one more than the number of
NewItems and NewLines.

At two places in DosBox, I've commented out pairs of lines.
one of which should be enabled by deleting the FIRST "{".

---------------------------------------------------------------
     Listing 1 -- Globals & a USES addition
------------------------------------------------------------- }
uses Crt { ADD TO USES -- for a GoToXY in the "engine" }

const   { global }
  { DosCmd triggers DosShellx code w/o this flag }
  XCom : boolean = false;
  { Editable string constant - for DosCmd entries }
  CmdLn : string = ' ';
  { Editable string constants - for TASM menu item }
  TasmParams     : string[60] = '/?';
  TasmPath       : string[60] = 'c:\ta\tasm.exe ';
  { Command constants - fit into your own numbering }
  cmDosCmd       = 2000;
  cmDosShellx    = 2001;
  cmRunTASM      = 2002;

var   { global }
  { Carry strings into DosBox for Exec parameters }
  BoxPath        : string[60];
  BoxParams      : string[60];
  { Used to collect Exit mode from Input boxes }
  InputResult    : word;

{ Add into TEditorApp object definition }
    procedure DosBox;
    procedure DosShellx;
    procedure DosCmd;
    procedure RunTASM;

{ -----------------------------------------------------------
     Listing 2 -- DosBox, the "engine"
------------------------------------------------------------- }
procedure TEditorApp.DosBox;
const
  kbufStart : word   = $1E;
var
  { Vars used in order to set a PROMPT= into the
    key buffer in shell. The prompt will be [X]$P$G.
    A continuing reminder to EXIT back to program.
  }
  kbufHead  : word absolute $40:$1A;
  kbufTail  : word absolute $40:$1C;
  kBuf      : array[0..15] of word absolute $40:$1E;
  i, keys   : byte;
  s         : string[20];
  ch        : char;
  { DOS Shell separated from DOS Cmd or programs. }
  ComSpec   : boolean;

begin
  DoneSysError;
  DoneEvents;
  DoneVideo;
  DoneMemory;
 { SetMemTop(Ptr(BufHeapPtr, 0)); { -- for TV1 and Buffers }
 { DoneDosMem;         { -- for TV2, buffer mgmt in Memory }
  SwapVectors;
  { if DOS Shell invoked, inserts [X]$P$G prompt. }
  ComSpec := False;
  if (BoxPath = GetEnv('COMSPEC')) and (XCom = False) then
    Begin
      ComSpec := True;
      PrintStr('PROMPT>EXIT <ENTER> : returns to TVEdit');
      s       := 'PROMPT=[X]$p$g'#13;
      keys    := 15;
      asm cli end;
      kbufHead  := kbufStart;
      kbufTail  := kbufStart + 2*keys;
      for i     := 1 to keys do
        kBuf[pred(i)] := word(S[i]);
      asm sti end;
    end;
  { Execute program, command line, or shell }
  Exec(BoxPath, BoxParams);
  SwapVectors;
 { SetMemTop(Ptr(BufHeapEnd, 0)); { -- for TV1 and Buffers }
 { InitDosMem;         { -- for TV2, buffer mgmt in Memory }
  InitMemory;
  { Saves DOS Screen to reference Exec'd output }
  { Screen capture routine here }
  { If not DOS Shell, hold screen for user }
  if not ComSpec then
    begin
      gotoxy(1,25);
      PrintStr('Press any key to return to TVEdit...');
      while not keypressed do;  { do nothing }
      ch := Readkey;
      if ch = #0 then ch := Readkey;
    end;
  { Clear XCom flag if DOS Cmd set it }
  XCom := False;
  InitVideo;
  InitEvents;
  InitSysError;
  Redraw;
end;

{ ------------------------------------------------------------
     Listing 3 -- 3 front-ends for an internal DOS Command Line,
                  a DOS Shell, and a "wired in" program
------------------------------------------------------------- }
procedure TEditorApp.DosCmd;
begin
  InputResult := InputBox('DOS Command Line', 'DOS Prompt>',
                            CmdLn, 57);
  if InputResult <> cmCancel then
    begin
      XCom       := true;
      BoxPath    := GetEnv('COMSPEC');
      BoxParams  := '/c ' + CmdLn;
      DosBox
    end;
end;

procedure TEditorApp.DosShellx;

begin
  BoxPath   := GetEnv('COMSPEC');
  BoxParams := '';
  DosBox;
end;

procedure TEditorApp.RunTasm;
begin
  BoxPath   := TasmPath;
  BoxParams := TasmParams;
  DosBox
end;

{ ------------------------------------------------------------
     Listing 4 -- TEditorApp.HandleEvent items
                  and changed or added File Menu items
------------------------------------------------------------- }
{ Add to TEditorApp.HandleEvent--under "cmShowClip:Showclip". }
cmDosShellx : DosShellx;
cmDosCmd : DosCmd;
cmRunTasm : RunTasm;

{ Menu lines: Change the DOS Shell line, add the other three. }
NewItem('~D~OS shell', '', kbNoKey, cmDosShellx, hcNoContext,
NewItem('DOS C~m~d', '', kbNoKey, cmDosCmd, hcNoContext,
NewItem('~T~ASM', '', kbNoKey, cmRunTasm, hcNoContext,
NewLine(
{ ------------- end of listing ------------------------------ }
