7 #                   t  &@      t                          "  $  "  $  "$    "$    "$   "2 <  "n    "n    "n    "n 
  "x   "    "  %( x  "n    %    %   % *  &     "$      %    %    %    %    &     %    %    %    %    %    %    // Windows Font Cache, By David Block, 1993
 static HGLOBAL hFontCache = NULL;  // Memory handle for Font cache
 static WORD nCacheSize;		   // Number of slots in cache
 //******************************************************************
 // FontCacheInit(WORD nSize)
 // This routine is responsible for allocating memory for the font
 // cache.  The cache is written so that if we can't allocate
 // memory for the cache it will still operate properly, but, with
 // uncached fonts.
 // Returns NULL if there was not enough memory for the font cache.
 //***************************
 int FontCacheInit(WORD nSize)
 {
 	hFontCache = GlobalAlloc(GHND, nSize*sizeof(FONTHDR));
 	if (hFontCache)			// if successful
 		nCacheSize = nSize;		// save the size
 	return(hFontCache);
 }
 
 //******************************************************************
 // FontCacheFini
 // This routine must be called when exiting your windows program
 // to free the cached fonts, and the memory used to cache them.
 //***************************
 void FontCacheFini()
 {
 	FlushFontCache();
 	GlobalFree(hFontCache);
 	hFontCache = NULL;
 }
 
 //******************************************************************
 // GetFontHandle(LOGFONT FAR *lf)
 // This routine is used to cache font handles in memory.  Whenever
 // it is called, it searches the list of cached fonts, and, if the
 // requested font is found, it will return its handle.  Otherwise,
 // it will create the font.  It will then allocate memory to hold
 // the font information to cache it for next time.
 // Returns the handle to the font.
 //***************************
 HFONT GetFontHandle(LOGFONT FAR *lf)
 {
 	HFONT hFont;
 	FONTHDR FAR *pFontList;
 
 	if (hFontCache != NULL &&
 		(pFontList = (FONTHDR FAR *) GlobalLock(hFontCache))
                                                           != NULL) {
 		if ((hFont = FindFont(lf,pFontList)) == NULL)	
                                                       //font cached?
 			hFont = NewFont(lf,pFontList);			
                                                 // no, make new font
 		GlobalUnlock(hFontCache);
 	}
 	else 	// We can't cache the font, so just create it and
 				// return the handle.
 		hFont = CreateFontIndirect(lf);
 
 	return hFont;
 }
 
 //******************************************************************
 // FindFont(LOGFONT FAR *lf,FONTHDR FAR *pF)
 // Search the list of cached fonts for one with a matching LOGFONT
 // structure. If a font is found with a matching structure, it will
 // return its handle.  Otherwise, it returns NULL.
 //***************************
 static HFONT FindFont(LOGFONT FAR *lf,FONTHDR FAR *pF)
 {
 	int i=0;
 
 	while (i<nCacheSize && pF[i].hFont != 0) {
 		if (_fmemcmp((void FAR *) &pF[i].lf,
                              (FONTHDR FAR *) lf,sizeof(LOGFONT))==0)
 				return(pF[i].hFont);
 		++i;
 	}
 	return NULL;	// return NULL if font not in list
 }
 
 //******************************************************************
 // NewFont(LOGFONT FAR *lf,FONTHDR FAR *pF)
 // Create a font using the passed logfont structure.  If possible,
 // try to cache the font by adding it to the font list.
 // If the cache is full it will automatically flush the cache to
 // force rebuilding the cache.
 // Returns the handle of the font.
 //***************************
 static HFONT NewFont(LOGFONT FAR *lf,FONTHDR FAR *pF)
 {
 	HFONT hf;
 	int i;
 
 	hf = CreateFontIndirect(lf);	// Create the requested font
 	for (i = 0; i<nCacheSize; i++) {     // Find an unused slot
 		if (pF[i].hFont == NULL) break;
 	}
 #if AUTOFLUSH		// If automatic flushing is enabled
 	if (i == nCacheSize) {	// cache is full...
 		DoFlush(pF);	   // flush the cached font handles
 		i = 0;		   // reset to use the first slot
 	}
 #endif
 	if (i != nCacheSize) {		
                             // If slot was found... cache the info
 		pF[i].hFont = hf;		
                             // Put handle in font cache object
 		_fmemcpy((void FAR *) &pF[i].lf, (FONTHDR FAR *) lf,
 					sizeof(LOGFONT));	
                                       // store corresponding logfont
 	}
 	return hf;
 }
 
 //******************************************************************
 // FreeFont(HFONT hFont)
 // If the font handle is found in the cached fonts list, don't do
 // anything.  Otherwise, delete the font.
 //***************************
 void FreeFont(HFONT hFont)
 {
 	int i;
 	FONTHDR FAR *pFontList;
 
 	if (hFontCache != NULL &&
 	(pFontList = (FONTHDR FAR *) GlobalLock(hFontCache))!=NULL){
 		for (i = 0; i<nCacheSize; i++) {	
                                         // if handle cached, keep it
 			if (pFontList[i].hFont == hFont)
 				break;
 		}
 		GlobalUnlock(hFontCache);
 	}
 	if (i == nCacheSize)		// if font was not found...
 		DeleteObject(hFont);	// delete the font.
 }
 
 //******************************************************************
 // FlushFontCache()
 // This routine is used to enable re-building a font list that has
 // no unused fonts in it. It can be called when processing WM_PAINT
 // messages, or, After FlushFontCache is called, the system will
 // automatically rebuild a new one.
 // This routine should be called before the program exits to free
 // all font handles.
 //***************************
 void FlushFontCache()
 {
 	FONTHDR FAR *pFontList;
 	
 	if (hFontCache == NULL) return;//There's no cache, so return
 	if ((pFontList = (FONTHDR FAR *)GlobalLock(hFontCache))
                                                            !=NULL) {
 		DoFlush(pFontList);
 		GlobalUnlock(hFontCache);			
                                                 // unlock the memory
 	}
 	else MyMessageBox(IDS_CACHESTUCK, NULL, MB_ICONSTOP|MB_OK);
 }
 
 //******************************************************************
 // DoFlush(FONTHDR FAR *pF)
 // This is a private function used to flush all entries in the
 // cache.  It deletes the font handles, and set's them to NULL
 // to indicate that the slots are empty.  It is used by
 // FlushFontCache() and NewFont().
 //***************************
 static void DoFlush(FONTHDR FAR *pF)
 {
 	int i;
 
 		for (i = 0; i<nCacheSize; i++) {		
                                           // for each font handle...
 			if (pF[i].hFont) {		
                                           // If valid handle...
 				DeleteObject(pF[i].hFont);	
                                           // Free the font
 				pF[i].hFont = NULL;
                                           // indicate slot available
 			}
 		}
 }
u                                                                                                                                          // Windows Font Cache, By David Block, 1993
 static HGLOBAL hFontCache = NULL;  // Memory handle for Font cache
 static WORD nCacheSize;		   // Number of slots in cache
 //******************************************************************
 // FontCacheInit     t  w                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          
 @      
 :F         ,  p      
  P        )  H  g  j          
    R  d            3  M  b  e  g        X        7  V  |              D  v      	(  	E  	I  	  	  	  	  	  	  	  
  
L  
  
  	  (  `  c  n  p        %  -  1  c  f  h      
  
X  
  
  
  
  4  7  C  L  N          #  P     !  c  P              3  s      
           f        
  )  ,  5  O  Q  m        <  H  M  j  n            .  r        a  w              F        	  
  K  N  P        3  l              	  O  h          e  k  p  t                                                                                    !  S               
               t   t      
L    
  t     @      @     >P           w      P  t        
         ! "                            x(){"""""!"$"1"2"3"4"6"7"="D"E"G"R"S"Z"""""""""""""""""""""""""""""""""""""""""""""# #########****3-3.3U3V3W3X3Y3Z3[3\333333333333333888888999999/90919298999:9;9O9P9Q9R9S9T9U9V9W9X9Y9Z999999999999999999999999999999999999999999999:::	:
:::
::::::::::::::::::: :!:":#:$:%:&:0:1:2:5:6:7:8:9:::E:F:G:H:I:J:K:L:O:P:Q:Y:Z:e:f:g:h:i:j:k:l:u:v:w:x:y:z:{:|:::::::::::::::    H H    (FG(    H H    (    d       '                     @                         =/  R    B      H 
-:LaserWriter 
           :FB Letter Gothic Bold               ( e ( B    Cool Barbara  Cool Barbara                                                                                                                                                                                                                                                                                                                                                                                                                                                                