//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+	   				|
//+          SUSCEPT.H			|	Written by O.Rasizade
//+  DEFINITIONS FOR SUSCEPTEMETER	| 	Copyright June 1992
//+         				|
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#ifndef __SUSCEPT_H
#define __SUSCEPT_H

#if __STDC__
#define _Cdecl
#else
#define _Cdecl  cdecl
#endif

#include <camac.h>

#define CNF_NAME	"susc220.cnf"
#define TMP_DATA	"susctmp.$$$"


//---------------- EXTERNALS --------------------

extern void interrupt camISR(void);

extern byte rCntSusc,iCntSusc,rCntTermo,iCntTermo;

extern signed int A1x8,B1x8,rT,iT;//accumulated real and im part
				// of susceptibility and termovoltage
				// nessesary to divide by 8

extern byte errCodeISR;	// from SUSC_ISR module. Meaning:
			// 1: "ADC interrupt" (ADC int is disabled)
			// 2: "psd Status error" ( if it is neither 1 nor 2)
			// 3: "ADC timeout" ( ADC is silent too long )

extern byte psdStatus;  // from SUSC_ISR module. Meaning:
			// 0 - error in measuring sequence
			// 1 - making sin*sin
			// 2 - making cos*cos
		// from SUS_MEAS.C
extern boolean measInProgress;	// if nonzero then measurement is in progress
extern double a1,b1,Temp,R,disbalance,module;//real and im part of susceptibility and termovoltage
extern float fi;
extern double cosfi,sinfi; // balance
extern int constI,altI;	 //constant and alternate currents
extern int gainAmpSusc,gainAmpTermo,K_gain;

//--------------- CAMAC STATIONS --------------

#define Ampl_N	9	// Two channel amplifier
#define PSD_N   7	// Phase sens.detector
#define DAC_N   6
#define ADC_N   1

#define ADC_ZERO 0x7ff
#define IMAX	600.	// max currents for DAC's (ma)
#define CUR_LIMIT 750	// limit of summury (AC+DC) current
#define	maskLAM  PSD_N  // LAM mask for KK009

//-------------- CAMAC MODULE'S COMMAND -----------------

		//--------- Amplifier -------
#define setAmpl_1(j)	poke(CamBase,Ampl_N*0x400+18*2,(j))
#define setAmpl_2(j)	poke(CamBase,Ampl_N*0x400+0x40+18*2,(j))

		//--------- Phase Sen. Detector-------
//#define clrLamPSD	poke(CamBase,PSD_N*0x400+4*0x40+18*2,0)
#define clrLamPSD	poke(CamBase,PSD_N*0x400+0*0x40+2*2,0)
							 // clears LAM
#define swInPhasePSD	poke(CamBase,PSD_N*0x400+0x40+18*2,8)
							 //switch to
#define swOutPhasePSD	poke(CamBase,PSD_N*0x400+0x40+18*2,0)

		//--------- DAC and heater ----------------------------
#define HeatON		poke(CamBase,DAC_N*0x400+16*2,1)
#define HeatOFF		poke(CamBase,DAC_N*0x400+16*2,0)
 #ifdef __cplusplus
 extern "C" {
 #endif
int _Cdecl far setConstI(int i);	// set constant current i=current
int _Cdecl far setAltI(int i);	// set alternate current i=current
 #ifdef __cplusplus
 }
 #endif

		//--------- ADC ---------
#define startADC	poke(CamBase,ADC_N*0x400+25*2,0)
							// also clears LAM
#define rdADC		0xfff&peek(CamBase,ADC_N*0x400+2*2)
							// also clears LAM
#define setADCrange	poke(CamBase,ADC_N*0x400+17*2,1)
#define setADCch(chanN)	poke(CamBase,ADC_N*0x400+0x40+17*2,(chanN))
				// needs delay about 50 micro sec
#define adc2volt(n)	((n)*5.0/0xfff) // converts ADC read data
void _Cdecl  updateIndicators(void);	//  to volts

//-------------------- FUNCTION DECLARATIONS ------------
 #ifdef __cplusplus
 extern "C" {
 #endif
void _Cdecl InitSuscept(void);
void _Cdecl quitSuscept(void);
double _Cdecl MeasureTemp(double *Res);//Res:measured value of thermo resistor
void _Cdecl errExit(void);

	//---------------------- HYSTERESIS --------

int _Cdecl InitHyst(void);// INITIALIZE HYSTERESIS MEASUREMENT
			  //	returns: 0 : OK
			  //		-1 : cannot create data file
int _Cdecl InitTdep(void);// INITIALIZE T-DEPENDENCE MEASUREMENT
			  //	returns: 0 : OK
			  //		-1 : cannot create data file
void _Cdecl measureA1B1T(void);

 #ifdef __cplusplus
 }
 #endif

#endif __SUSCEPT_H