//
//  AC SUSCEPTEMETER
//
//     BUTTON AND PAINT PROCEDURES (bp and pp) 
//
//                       |	 Written by O.Rasizade
//    			 | 	  (c) Sept 1992, 1993
//                       |
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++


#include <vphead.h>	// must be included first
#pragma hdrstop

#include <vpbase.h>
#include <vpboard.h>
#include <vpoutbox.h>
#include <vpinbox.h>
#include <vpindic.h>
#include <vpgraph.h>
#include <vpbutt.h>
#include <vputil.h>

#include <suscept.h>
#include "su_bp.h"

#define CHOOSE_TITLE_FONT	0
#define CHOOSE_TITLE_FONT_SIZE	1

//++++++++++++++++ GLOBAL VARIABLES ++++++++++++++++
int K_gain_temp;			// temporary gain for choosing indicator
//------------------------ AMPLIFIER ----------------------------
//------------------ GAIN CONSTANTS
#define N_GAIN			11	// number of gain sets
const struct{byte code;
	     char *value;
	     long Ku;
	     }	gain[N_GAIN]={	{0x0a,"150*Kf",150000},
				{0x09,"300*Kf",300000},
				{0x0b,"450*Kf",450000},
				{0x06,"600*Kf",600000},
				{0x05,"1200*Kf",1200000},
				{0x07,"1800*Kf",1800000},
				{0x14,"2400*Kf",2400000},
				{0x26,"600",600},
				{0x25,"1200",1200},
				{0x27,"1800",1800},
				{0x34,"2400",2400}
			      };

//++++++++++++++++ REFERENCES TO OBJECTS ++++++++++++++++

extern indbutton *butHeater;
extern Indicator<double> *indDisbal,*indModule,*indR;
//extern TSInbox *ptibBalabce,*ptibDC,*ptibAC;
_Indicator *indGain,*indChoose;

//+++++++++++++++++++ PROCEDURES ++++++++++++++++++++++

//---------------------- CAMAC CONTROL PANEL BUTTONS ----

	//---------------- HEATER---
void far bpHeater(void)
{
 butHeater->Invert();
 (butHeater->on)?HeatON:HeatOFF;
}

	//---------------- ENTER BALANCE  ---
void far bpEnterBal(void)// popup
{
 Enter("Enter","Angle(rad) = ","%f", &fi);
 sinfi=sin(fi); cosfi=cos(fi);
}

	//---------------- R INDICATOR ---
void far ppR(void)
{ 			// perm ind
 indR->Paint();
 indR->Put(R);
}

void far bpR(void)
{
 ppR();
 indR->MkActive();
}


	//---------------- DISBALANCE ANGLE ----------
void far ppDisbal(void)
{ 			// perm ind
 indDisbal->Paint();
 indDisbal->Put(disbalance);
}

void far bpDisbal(void)
{
 ppDisbal();
 indDisbal->MkActive();
}
	//---------------- MODULE ----------
void far ppModule(void)
{ 			// perm ind
 indModule->Paint();
 indModule->Refresh();
}

void far bpModule(void)
{
 ppModule();
 indModule->MkActive();
}

//------------------------------------ CHOOSE GAIN ----------

void far  bpGain(void)
{
#define chBUTSHF 	30
#define chINDSHF 	20
int ax0=maxx>>1,ay0=maxy>>2;

	//------------------- COLOR setting for indicators
const indicatorcolors LCDred={
		       RED,	// color of title
		       DARKGRAY,// foreground color
		       YELLOW	// background color
		       };
const indicatorcolors LCDgreen={
		       LIGHTGREEN,	// color of title
		       DARKGRAY,// foreground color
		       YELLOW	// background color
		       };
butsystem bsGain;

settextstyle(CHOOSE_TITLE_FONT,HORIZ_DIR,CHOOSE_TITLE_FONT_SIZE);
_Indicator _indGain(
		ax0+chINDSHF,ay0+y__yy(textheight("p"))+4*SPACING,
		FIXED,"Current Gain",
		10,"%s",	// width of disp in chars,format
		UNFRAMED,procNULL,
		0,1,		//font and size of number
		SMALL_FONT,4,	//font and size of title
		plaquecoldflt,LCDred),

	_indChoose(
		ax0+chINDSHF,_indGain.ymax,FIXED,"Choose Gain",
		10,"%s",	// width of disp in chars,format
		UNFRAMED,procNULL,
		0,1,		//font and size of number
		SMALL_FONT,4,	//font and size of title
		plaquecoldflt,LCDgreen);

 indGain=&_indGain;
 indChoose=&_indChoose;
int axmax=_indChoose.xmax+chINDSHF;
	//---------------- Buttons ------
int  bxsz=(axmax-ax0-2*chBUTSHF)>>1;
butgrp gr1(ax0+chBUTSHF,_indChoose.ymax,bxsz,18);
  button butDec("<",'<',',',bpDec,SMALL_FONT,4);
  button butInc(">",'>','.',bpInc,SMALL_FONT,4);
 gr1.ShiftToX(ax0+chBUTSHF+(bxsz>>1));
 gr1.ShiftToY(butInc.ymax+6);
  button butEnter("Enter",13,13,bpEnter,SMALL_FONT,4);

Board ChooseGain(ax0,ay0,POPUP,"Pickup Amplifier",
		 axmax-ax0,butEnter.ymax-ay0+chBUTSHF,// size of board
		 procNULL,
		 CHOOSE_TITLE_FONT,CHOOSE_TITLE_FONT_SIZE);

	//---------------- Paint whole board
ChooseGain.Paint();

_indGain.Paint();
_indChoose.Paint();

_indGain.Put(gain[K_gain].value);
_indChoose.Put(gain[K_gain].value);

gr1.Paint();

K_gain_temp=K_gain;

bsGain.NextButton();
bsGain.Loop(procDummy);
ChooseGain.Remove();
}
		//------ CHOOSE GAIN BUTTON PROCs ----
void far  bpInc(void)
{
 if (K_gain_temp< N_GAIN-1)
   K_gain_temp++;
 else
   K_gain_temp=6;
 indChoose->Put(gain[K_gain_temp].value);
}

//---------
void far  bpDec(void)
{
 if (K_gain_temp> 0)
   K_gain_temp--;
 else
   K_gain_temp=0;
 indChoose->Put(gain[K_gain_temp].value);
}

//---------
void far  bpEnter(void)
{
 K_gain=K_gain_temp;
 indGain->Put(gain[K_gain].value);
 gainAmpSusc=gain[K_gain].code;
 setAmpl_2(gainAmpSusc);	//gain for suscept
}
//----------

//----------------------------- QUIT ---
void far  bpQuit(void)
{
 object::SaveCnfg(CNF_NAME);
 camDisInt();
 quitSuscept();
 QuitVirtualPanels();
 exit(0);
}

