//
//  AC SUSCEPTEMETER
//
//   HYSTERESIS
//     BUTTON AND PAINT PROCEDURES (bp and pp)
//
//                       |	 Written by O.Rasizade
//    			 | 	  (c) Oct 1992, 1993
//                       |
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#include <vphead.h>	// must be included first
#pragma hdrstop

#include <vpbase.h>
#include <vpinbox.h>
#include <vpindic.h>
#include <vpgraph.h>
#include <vpbutt.h>
#include <vputil.h>

#include "suscept.h"
#include "su_bp.h"

//-------------------- GLOBAL VARIABLES -------------
extern Indicator<double> *indDisbal,*indModule;
extern TSInbox<int> *ptibAC, *ptibDC;
extern Board *Hysteresis;
extern FILE *dat;
extern char nameHystDat[];	// name of data file
int limDC=512,delDC=1,N=1,hyDelay=500,statusHyst=11;
int _limDC=512;

	//---------------------- BACKGROUND PROCEDURE ---------
void far  HystBackgr(void)
{
static int DC;
//---------------------- GRAPH SECTION ---
static int dc0;
static float a10,b10;
char graphtitle[30]="Hysteresis : ";

Graph<float,float> *
pgrHyst1 = new Graph<float,float>  (
	x0s,y0s,PERM,graphtitle,
	14,12,	/* number of x & y div.			*/
	25,20,	/* number of pixels in every div.	*/

	-_limDC,-2.5,	/* values of x,y at origin	*/
	_limDC/7.,5./12.,/* values of x,y div.		*/
					  // Hereafter defaults are used
	procDummy,
	"Constant Field","A1(red) B1(yellow)",	/* text on the axises*/
	"%.1f","%.1f"); 	        /* format of values on divisions*/
 pgrHyst1->OnScreen=1;
 switch (statusHyst)
 {
  case 0:			   //--- Init
	   if (InitHyst()==-1)
	      {DisplayErrorMessage("Cannot create data file");
	      statusHyst=10;}
	   else
	    {
	     strcat(graphtitle,nameHystDat);
	     pgrHyst1->Paint();
	     pgrHyst1->PutDot(0,a1,RED);
	     pgrHyst1->PutDot(0,b1,YELLOW);
	     dc0=DC=0; a10=a1; b10=b1;
	     statusHyst=1;
	     }
	   break;
  case 1:			//--- Incremential measurement
	  delay(hyDelay);
	  measureA1B1T();
	  sound(1000);
	  delay(0);
	  nosound();
	  fprintf(dat,"\n%d  %.4f   %.4f",constI,a1,b1);
	   pgrHyst1->PutLine(dc0,a10,DC,a1,RED);
	   pgrHyst1->PutLine(dc0,b10,DC,b1,YELLOW);
	   dc0=DC; a10=a1; b10=b1;
	  updateIndicators();
	  ptibDC->Refresh();
	  //	SetTemperature1();
	  if ((DC+delDC) <= limDC )
		{DC+=delDC; setConstI(DC);}	// continue this incr loop
	  else
                statusHyst=2;			// start decr loop
	  /*  if ((limDC-=delDC) >0 )
	       {
		statusHyst=2;			// start decr loop
		indLimDC->Put(limDC);
		}
	    else
		statusHyst=10;			// end Hyst measurement
           */
	  break;
  case 2:			//--- Decremential measurement
	  if ((DC-delDC) < (-limDC))
            statusHyst= 1;  // start inc loop
	   /*{
	    statusHyst=((limDC-=delDC) > 0)? 1:10;// start inc loop : end Hyst measurement
	    indLimDC->Put(limDC);
	    }*/
	  else		// continue this decr loop
	  {
	   setConstI(DC-=delDC);
	   delay(hyDelay);
	   measureA1B1T();
	    sound(1000);
	    delay(0);
	    nosound();
	   pgrHyst1->PutLine(dc0,a10,DC,a1,RED);
	   pgrHyst1->PutLine(dc0,b10,DC,b1,YELLOW);
	   dc0=DC; a10=a1; b10=b1;
	   updateIndicators();
	   fprintf(dat,"\n%d   %.4f   %.4f",constI,a1,b1);
	   ptibDC->Refresh();
	   //	SetTemperature1();
	   }//else
	   break;
  case 10:		//--- Stop Hyst measurement
	  fclose(dat);
	  measInProgress=0;
	  statusHyst=11;	// switch backgr measurement in idle mode
	  if ( !Confirm(" Save data file ? ", YES) )
		unlink(nameHystDat);
	  pgrHyst1->Remove();
	  break;
  case 11:;		//--- Dummy entry. Measurement is idle.
 }
delete pgrHyst1;
}

//-----------------  HYSTERESIS BOARD  ------

		//------ HYSTERESIS BOARD BUTTON PROCs ----

//------------------------------------ AC1 -----
int far  tibpAC1(int AC)
{
 setAltI(AC);
 return AC;
}

//------------------------------------ START -----
void far  bpStart(void)
{
if (!measInProgress)
 {
  statusHyst=0;	// start backgr measurement
  _limDC=limDC;
 }
}

//------------------------------------ STOP -----
void far  bpStop(void)
{
if (measInProgress)
 {statusHyst=10;}	// switch backgr measurement in stop mode
}

//------------------------------ HYST BUTTON PROCEDURE ------
void far  bpHyst(void)
{
int X0=Hysteresis->x0, Y0=Hysteresis->y0p+5;

statusHyst=11;		// No measurement - idle backgr. proc

butsystem *
 pbsHyst = new butsystem ;

 TSInbox<int> *ptibAC1= new TSInbox<int>
	( X0, Y0, "AC:",
	  5, &altI,"%d","%d", tibpAC1,SMALL_FONT, 4,plaquecoldflt,ibxcolLum);

 TSInbox<int> *ptibDelay= new TSInbox<int>
	( ptibAC1->xmax, Y0, "Delay:",
	  5, &hyDelay,"%d","%d",NULL,SMALL_FONT, 4,plaquecoldflt,ibxcolLum);

 TSInbox<int> *ptibLimDC= new TSInbox<int>
	( ptibDelay->xmax, Y0, "DC limit:",
	  5, &limDC,"%d","%d",NULL,SMALL_FONT, 4,plaquecoldflt,ibxcolLum);

 TSInbox<int> *ptibDelDC= new TSInbox<int>
	( ptibLimDC->xmax, Y0, "Delta:",
	  5, &delDC,"%d","%d",NULL,SMALL_FONT, 4,plaquecoldflt,ibxcolLum);

 TSInbox<int> *ptibN= new TSInbox<int>
	( ptibDelDC->xmax, Y0, "N:",
	  5, &N,"%d","%d",NULL, SMALL_FONT, 4,plaquecoldflt,ibxcolLum);


int axmax=ptibN->xmax;
	//---------------- Buttons ------
#define chBUTSHF 	10

butgrp gr2(X0+chBUTSHF,ptibN->ymax+6,(ptibN->xmax-ptibAC1->x0-2*chBUTSHF)>>1,20);
  button butStop("stoP measurement",'P','p',bpStop,SMALL_FONT,4);
  button butStart("Start measurement",'S','s',bpStart,SMALL_FONT,4);

Hysteresis->ChangeSize(axmax-X0,butStart.ymax-Hysteresis->y0+chBUTSHF);// size of board

	//---------------- Paint whole board
Hysteresis->Paint();

ptibAC1->Paint();
ptibDelay->Paint();
ptibLimDC->Paint();
ptibDelDC->Paint();
ptibN->Paint();

ptibAC1->Refresh();
ptibDelay->Refresh();
ptibLimDC->Refresh();
ptibDelDC->Refresh();
ptibN->Refresh();

gr2.Paint();

pbsHyst->NextButton();
do
  pbsHyst->Loop(HystBackgr);
while(measInProgress);
delete pbsHyst;

 ptibAC->Refresh();

Hysteresis->Remove();
Hysteresis->MkActive();
object::RepaintScr();

delete ptibAC1;
delete ptibDelay;
delete ptibLimDC;
delete ptibDelDC;
delete ptibN;

}//----- bpHyst(void)

//+++++++++++++++++++++++++++++++++++++++++++++++++++++
//------------------------------ HYSTERESIS GRAPH -----

int  find_ch(char c)
{
int ch;
 while ( ( (ch=getc(dat)) != c ) && (ch!=EOF) );
 return ch;
}

//------------------------
void far  bpHystGraph(void)
{
int dc0,dc1;
float a10,a11,b10,b11;
int blank;

 if ( (dat = fopen(nameHystDat,"rt")) == NULL )
   DisplayErrorMessage("No measurement has been made yet");
 else
 {
  find_ch('=');
  fscanf(dat,"%d",&blank);
  find_ch('=');
  fscanf(dat,"%d",&limDC);
  find_ch('@');
 char graphtitle[30]="Hysteresis : ";
 Graph<float,float>  grHyst(
	x0s,y0s,POPUP,strcat(graphtitle,nameHystDat),
	14,12,	/* number of x & y div.			*/
	25,20,	/* number of pixels in every div.	*/

	-limDC,-2.5,	/* values of x,y at origin	*/
	limDC/7.,5./12.,/* values of x,y div.		*/
					  // Hereafter defaults are used
	procNULL,
	"Constant Field","A1(red) B1(yellow)",	/* text on the axises*/
	"%.1f","%.1f"); 	        /* format of values on divisions*/

  grHyst.Paint();
  fscanf(dat,"%d%f%f",&dc0,&a10,&b10);
  grHyst.PutDot(dc0,a10,RED);
  grHyst.PutDot(dc0,b10,YELLOW);
  while ( fscanf(dat,"%d%f%f",&dc1,&a11,&b11)!=EOF )
  {
   grHyst.PutLine(dc0,a10,dc1,a11,RED);
   grHyst.PutLine(dc0,b10,dc1,b11,YELLOW);
   a10=a11;
   b10=b11;
   dc0=dc1;
   }
  fclose(dat);
  getch();
  grHyst.Remove();
  }//-- else
}//--------------- END of bpHystGraph(void) ---------
