//
//	     AC SUSCEPTEMETER
//
//	     MAIN FUNCTION 
//
//                       |	 Written by O.Rasizade
//    			 | 	  (c) Sept 1992, 1993
//                       |
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

#include <vphead.h>	// must be included first
#pragma hdrstop

#include <vpbase.h>
#include <vpboard.h>
#include <vpoutbox.h>
#include <vpinbox.h>
#include <vpindic.h>
#include <vpgraph.h>
#include <vpbutt.h>
#include <vputil.h>

#include <suscept.h>
#include "su_bp.h"

  int far EGAVGA_driver_far[1];

//+++++++++++++++++++++++++++++++++++++++++
//++++++   GLOBAL VARIABLES +++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++

	//-------- POINTERS TO OBJECTS ----
Indicator<double> *indTemp,*indInphase,*indOutphase;
Indicator<double> *indDisbal,*indModule,*indR;
TSInbox<int> *ptibDC, *ptibAC;
Outbox *obxHelp;
Board *Hysteresis,*Tdependance;
indbutton *butHeater;

//+++++++++++++++++++++++++++++++++++++++++++++++++
//++++++++++++++++++++ PROCEDURES +++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++


//------------------------------------- PRINT ABOUT -----
#define LF_CR   gprintf_n(&xloc,&yloc,"")

void prnextr(int *xloc,int *yloc,char *text)
{
 setcolor(WHITE);
 gprintf(*xloc-1,*yloc-1,text);
 setcolor(DARKGRAY);
  gprintf(*xloc+1,*yloc+1,text);
 setcolor(LIGHTGRAY);
  gprintf_n(xloc,yloc,text);
}
//--------------------
void prnabout(int tfont)
{
int axl=maxxx>>1,ayl=maxyy>>1;
int ax0=axl>>1,ay0=ayl>>1;
int xloc=ax0,yloc=0;
Board about(
	x__xx(ax0),y__yy(ay0),	// left top coord where to paint the board
	POPUP,			// may be FIXED,PERM,POPUP
	"",	     	 	// title
	x__xx(axl),y__yy(ayl),		// size of board
	procNULL,tfont,4);	// set font for first row

 about.Paint(); // is put here to release far heap before font

 setviewport(ax0,ay0,3*ax0,3*ay0,CLIP_OFF);
 settextjustify(CENTER_TEXT,TOP_TEXT);
 LF_CR;
  prnextr(&xloc,&yloc,"A C");
 settextstyle(tfont,HORIZ_DIR,3);
  prnextr(&xloc,&yloc,"susceptometer");
 settextstyle(tfont,HORIZ_DIR,2);
  prnextr(&xloc,&yloc,"version 2.2");
 settextstyle(0,HORIZ_DIR,1);
 yloc+=10*yyspacing;
 setcolor(LIGHTGREEN);
  gprintf_n(&xloc,&yloc,"written by O.Rasizade");
  gprintf_n(&xloc,&yloc,"");
  gprintf_n(&xloc,&yloc,"Copyright NOSIR, 1992");

 getch();
 about.Remove();
}//-- END of PRINT ABOUT ----

//--------------------------- BACKGROUND PROCEDURE -----
void  updateIndicators()
{
 indTemp->Refresh();
 indInphase->Refresh();
 indOutphase->Refresh();
 if (indDisbal->OnScreen) indDisbal->Refresh();
 if (indModule->OnScreen) indModule->Refresh();
 if (indR->OnScreen)      indR->Refresh();
}

//---------------------------------
void far MainBackgr(void)
{
struct  time t;
static int sec,hund;

 gettime(&t);
 if (sec==t.ti_sec)
   if ((t.ti_hund-hund)< 50)
	return;

 double aa1=/*random(40000)/10.;*/ adc2volt((A1x8-ADC_ZERO*8)/8.); //@@@
 double bb1=/*random(40000)/10.;*/ adc2volt((B1x8-ADC_ZERO*8)/8.); //@@@
 a1=aa1*cosfi+bb1*sinfi; // balance
 b1=-aa1*sinfi+bb1*cosfi;
 module=sqrt(a1*a1+b1*b1);
 if (a1!=0.0) { disbalance=atan2(b1,a1);}
   else  { disbalance=M_PI_2;}

 Temp=/*random(2000)/10.;*/ MeasureTemp(&R);    //@@@
 updateIndicators();
 sec=t.ti_sec; hund=t.ti_hund;
 if (errCodeISR) errExit();
}
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//++++++++++++++++++++++++ MAIN+++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
main()
{
InitAndCopyright("* AC Susceptometer * Copyright (c) O.Rasizade, 1992, LNP, tel.66135 *");
prnabout(TRIPLEX_FONT);

butsystem bsMain(MASTER);

		//---------- TEMPERATURE INDICATOR ------
Indicator<double>
	_indTemp(0,0,FIXED,"Temperature",	// title
		10, &Temp,"%.2f K",// width of disp in chars,format
		UNFRAMED,procDummy,
		0,1,		//font and size of number
		SMALL_FONT,4);	//font and size of title
			//plaquecoldflt,LCDbright);

		//-------- AREA FOR MOVING OBJECTS IS DEFINED ------

xxmaxs=maxxx-_indTemp.xxmax+_indTemp.xx0-4;	xmaxs=x__xx(xxmaxs);
ymaxs=maxy-30; 					yymaxs=yy__y(ymaxs);
_indTemp.MovetoXY(xmaxs+2,y0s+2);

	       //-------------- VERTICAL PANEL ------
Board PanelVert(xmaxs+1,y0s,FIXED,"",
		maxx-xmaxs-1,maxy-y0s);	// size of board

		//---------- INPHASE VOLTAGE INDICATOR ------
Indicator<double>
    _indInphase(xmaxs+2,_indTemp.ymax,FIXED,"In Phase",
		10, &a1,"%.2f V",	// width of disp in chars,format
		UNFRAMED,procDummy,
		0,1,		//font and size of number
		SMALL_FONT,4),	//font and size of title

		//---------- OUTPHASE VOLTAGE INDICATOR ------
   _indOutphase(xmaxs+2,_indInphase.ymax,FIXED,"Out Phase",
		10, &b1,"%.2f V",	// width of disp in chars,format
		UNFRAMED,procDummy,
		0,1,		//font and size of number
		SMALL_FONT,4);	//font and size of title

indTemp=&_indTemp;
indInphase=&_indInphase;
indOutphase=&_indOutphase;

PanelVert.Paint();
_indTemp.Paint();
_indInphase.Paint();
_indOutphase.Paint();

	//------------- COMMON BAR PARAMETERS ------
#define heatIND_R 	4	// radius of LED

#define butFONT   	SMALL_FONT
#define butFONT_SIZE	4

#define barFONT   	SMALL_FONT
#define barFONT_SIZE	4
#define barBORDER_Y	4 // dist. between low border of bar and last button

int bar_xx0=xx__x(PanelVert.x0+SHADWIDTH+4),
    bar_xxmax=xx__x(PanelVert.xmax-SHADWIDTH-4);

	//------------ CAMAC CONTROLS -------

const int barCam_yy0=_indOutphase.yymax;
settextstyle(barFONT, HORIZ_DIR, barFONT_SIZE);

//-------- AC -----
const outboxcolors ibxcolLum1={
		       YELLOW,		// color of title
		       LIGHTGREEN,	// text color
		       YELLOW,		// high-lighted text
		       BLACK            // color of paper
		       };

 ptibAC = new TSInbox<int>
	 (bar_xx0,_indOutphase.ymax+y__yy(textheight("p"))+4*SPACING,
	 "AC(0..255):", 6, &altI,// width of disp in chars, variable
	  "%d","%d",	// scan and print format
	  setAltI, SMALL_FONT, 4,plaquecoldflt,ibxcolLum1);
//-------- DC -----
 ptibDC = new TSInbox<int>
	 (bar_xx0, ptibAC->ymax, "DC(-511..512):",
	  6, &constI,	// width of disp in chars,variable
	  "%d","%d",	// scan and print format
	  setConstI, SMALL_FONT, 4,plaquecoldflt,ibxcolLum1);

butgrp CamCtrl( bar_xx0+2*INDOFFSET+2*heatIND_R, ptibDC->ymax,
		60,18,VERT,0);
  button butEnterBal("Balance",'B','b',bpEnterBal,butFONT,butFONT_SIZE);
  indbutton _butHeater("Heater",'H','h',bpHeater,heatIND_R,butFONT,butFONT_SIZE);
  button butGain("Gain",'G','g',bpGain,butFONT,butFONT_SIZE);

butHeater=&_butHeater;
const int barCam_yymax=butGain.yymax+yy__y(barBORDER_Y);

	//---------- PAINT CAMAC CTRL PANEL -----
maxviewport;
setfillstyle(SOLID_FILL,BLUE);
bar(bar_xx0,barCam_yy0,bar_xxmax,barCam_yymax);
setcolor(LIGHTGRAY);
settextjustify(LEFT_TEXT,TOP_TEXT);
outtextxy(bar_xx0,barCam_yy0+yyspacing," CAMAC control");
ptibAC->Paint();
ptibDC->Paint();
ptibAC->Refresh();
ptibDC->Refresh();
CamCtrl.Paint();

		//-------------------- DISPLAY BUTTONS -------
const int barDisp_yy0=barCam_yymax+yy__y(16);
settextstyle(barFONT, HORIZ_DIR, barFONT_SIZE);

butgrp bgrDisp( bar_xx0+2*INDOFFSET+2*heatIND_R,
		y__yy(barDisp_yy0+textheight("p"))+4*SPACING,
		60,18,VERT,0);
  button butR("R",'R','r',bpR,butFONT,butFONT_SIZE);
  button butModule("Module",'M','m',bpModule,butFONT,butFONT_SIZE);
  button butDisbal("disBal",'B','b',bpDisbal,butFONT,butFONT_SIZE);

const int barDisp_yymax=butDisbal.yymax+yy__y(barBORDER_Y);

	//------- PAINT DISPLAY PANEL -----
setfillstyle(SOLID_FILL,BLUE);
maxviewport;
bar(bar_xx0,barDisp_yy0,bar_xxmax,barDisp_yymax);
setcolor(LIGHTGRAY);
settextjustify(LEFT_TEXT,TOP_TEXT);
outtextxy(bar_xx0,barDisp_yy0+yyspacing," Display");
bgrDisp.Paint();

	//------ DISPLAY INDICATORS --------
Indicator<double>
//----- DISBALANCE -----
   _indDisbal(x0s,y0s,PERM,"Disbalance",
	  12, &disbalance,"%.3lf rad",	// width of disp in chars,format
	  FRAMED,ppDisbal,
	  0,1),	       		//font and size of number

//-------- R -----
   _indR(x0s,y0s,PERM,"Thermo R",
	  12, &R,"%.4lf K",	// width of disp in chars,format
	  FRAMED,ppR,
	  0,1),		//font and size of number

//----- MODULE -----
   _indModule(x0s,y0s,PERM,"Module",
	  12, &module,"%.3lf",	// width of disp in chars,format
	  FRAMED,ppModule,
	  0,1);	       		//font and size of number

indR=&_indR;
indModule=&_indModule;
indDisbal=&_indDisbal;

		//----------------- HELP ------

Outbox _obxHelp(maxx>>2,maxy>>2,POPUP,"Help",
	     35,10,		// size of board
	     FRAMED,
	     bpHelp,3,4);	// title font
obxHelp=&_obxHelp;

		//----------- HYSTERESIS PANEL ------
Board _Hysteresis(x0s,y0s,POPUP,"Hysteresis measurement",
		  0,0,bpHyst,// size of board
		  HYST_TITLE_FONT,HYST_TITLE_FONT_SIZE);
Hysteresis=&_Hysteresis;

		//----------- T-DEPENDANCE PANEL ------
Board _Tdependance(x0s,y0s,POPUP,"T-dep. measurement",
		  0,0,bpTdep,// size of board
		  HYST_TITLE_FONT,HYST_TITLE_FONT_SIZE);
Tdependance=&_Tdependance;


		//---------- HORIZONTAL BUTTONS -------

Board PanelHoriz(0,ymaxs+1,FIXED,"",xmaxs,maxy-ymaxs-1/*size of board*/);

butgrp HorizButtons(3,maxy-25,70,21,HORIZ,2);
 button butQuit("Quit",'Q','q',bpQuit,0,1,quittexcol,quitbutcol);
 button butHelp("Help",'h','H',bpHelp);
  HorizButtons.ShiftX(10);
 button butHyst("hYster",'Y','y',bpHyst);
 button butHystGraph("Graph",'G','g',bpHystGraph);
  HorizButtons.ShiftX(10);
 button butTdep("T-dep",'T','t',bpTdep);
 button butTdepGraph("gRaph",'R','r',bpTdepGraph);


PanelHoriz.Paint();
HorizButtons.Paint();

		//---------- PROGRAM ---------
 InitCamac();
 InitSuscept();
 camEnInt();

 bsMain.NextButton();
 bsMain.NextButton();

 object::LoadCnfg(CNF_NAME);
 object::RepaintScr();

 bsMain.Loop(MainBackgr);
 bpQuit();
}
//++++++++++++++++++++++++ END OF MAIN ++++++++++++++++++++++++
