//
//	AC SUSCEPTEMETER
//
//   		T-DEPENDANCE MEASUREMENT
//
//     BUTTON AND PAINT PROCEDURES (bp and pp)
//
//                       |	 Written by O.Rasizade
//    			 | 	  (c) Oct 1992, 1993
//                       |
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#include <vphead.h>	// must be included first
#pragma hdrstop

#include <vpbase.h>
#include <vpinbox.h>
#include <vpindic.h>
#include <vpgraph.h>
#include <vpbutt.h>
#include <vputil.h>

#include <suscept.h>
#include "su_bp.h"
//----------------- DECLARATIONS --------------
char  find_ch(char c); // defined in su_hystb.cpp

//-------------------- GLOBAL VARIABLES -------------
indbutton *pbutHeat1;
_Indicator *indN1;
extern Indicator<double> *indDC,*indDisbal,*indModule;
extern indbutton *butHeater;
extern Board *Tdependance;
extern FILE *dat;
extern char nameTdepDat[];	// name of data file
int N1=1,statusTdep=11;
int heatIntensity=1;

double minT=77.,maxT=170.,step=.1;
float _maxT=170.,_minT=77.;
int counter=1;
	//---------------------- BACKGROUND PROCEDURE ---------

void far  TdepBackgr(void)
{
static float trigT;
//---------------------- GRAPH SECTION ---
static float Temp0,a10,b10;
static double ac_a1=0.,ac_b1=0.,ac_Temp=0.;
static n=0;

 Graph<float,float>  grTdep1(
	x0s,y0s,PERM,nameTdepDat,
	15,12,	/* number of x & y div.			*/
	25,20,	/* number of pixels in every div.	*/

	_minT,-2.5,	/* values of x,y at origin	*/
	(_maxT-_minT)/15.,5./12.,	/* values of x,y div.		*/
					  // Hereafter defaults are used
	procDummy,
	"Temperature","A1(red) B1(yellow)",	/* text on the axises*/
	"%.1f","%.2f"); 	        /* format of values on divisions*/
 grTdep1.OnScreen=1;
 measureA1B1T();
 updateIndicators();

 switch (statusTdep)
 {
  case 0:			   //--- Init
	   if (InitTdep()==-1)
	    {
	     DisplayErrorMessage("Cannot create data file");
	     statusTdep=10;
	     }
	   else
	    {
	     grTdep1.Paint();
	     grTdep1.PutDot(Temp,a1,RED);
	     grTdep1.PutDot(Temp,b1,YELLOW);
	     Temp0=Temp; a10=a1; b10=b1;
	     trigT=Temp+step; statusTdep=1;
	    }
	    break;
  case 1:
	  if ( (Temp>maxT) || (Temp<minT) )
	     statusTdep=10;		     // end measurement
	  else
	   {
	    ac_a1+=a1; ac_b1+=b1; ac_Temp+=Temp;
	    n++;
	    indN1->Put(n);
	    if ((Temp>=trigT && step>0) || (Temp<=trigT && step<0))
	     {
	      a1=ac_a1/n ; b1=ac_b1/n ; Temp=ac_Temp/n;
	      fprintf( dat, "\n%.2f %.3f %.3f", Temp, a1, b1);
	      n=0; ac_a1=0; ac_b1=0; ac_Temp=0;
	      grTdep1.PutLine(Temp0,a10,Temp,a1,RED);
	      grTdep1.PutLine(Temp0,b10,Temp,b1,YELLOW);
	      a10=a1; b10=b1;
	      Temp0=Temp;
	      trigT+=step;
	       sound(1000);
	       delay(0);
	       nosound();
	      }//if
	     }//else
	    if (pbutHeat1->on)
	     {
	      if (!butHeater->on)
	       {
		HeatON;			// If heater is off
		butHeater->On();	//  switch it on
		delay(500);
		}//if
	      else if ( !(--counter) ) // decr counter and
		    {                  // if counter==0
		     counter=heatIntensity; // reload it
		     HeatOFF;                // and switch heater OFF
		     butHeater->Off();
		     delay(500);
		     }//else_if
	     }//if(pbpHeat->on)
            else
                HeatOFF;
	  break;
  case 10:		//--- Stop Tdep measurement
	  HeatOFF;
	  butHeater->Off();
	  measInProgress=0;
	  statusTdep=11;	// switch backgr measurement in idle mode
	  fclose( dat);
	  if ( !Confirm(" Save data file ? ", YES) )
	     unlink( nameTdepDat);
	  grTdep1.Remove();
	  break;
  case 11:;		//--- Dummy entry. Measurement is idle.
 }
}

//--------------------------- tib proc HEATER INTENSITY-----
int far  tibpIntens(int Intensity)
{
counter = Intensity;
return Intensity;
}

void far bpHeat1(void)
{
 pbutHeat1->Invert();
}


//------------------------------ Tdep BUTTON PROCEDURE ------
void far  bpTdep(void)
{
int X0=Tdependance->x0, Y0=Tdependance->y0p+5;

statusTdep=11;		// No measurement - idle backgr. proc

butsystem bsTdep;


 TSInbox<double> *ptibMinT = new TSInbox<double>
	( X0, Y0, "T min :",
	  7, &minT,"%lf","%5.1f", NULL,SMALL_FONT, 4,plaquecoldflt,ibxcolLum);

 TSInbox<double> *ptibMaxT= new TSInbox<double>
	( ptibMinT->xmax, Y0, "T max :",
	  7, &maxT,"%lf","%5.1f", NULL,SMALL_FONT, 4,plaquecoldflt,ibxcolLum);

 TSInbox<double> *ptibStep= new TSInbox<double>
	(  ptibMaxT->xmax, Y0, "Step :",
	  7, &step,"%lf","%5.2f", NULL,SMALL_FONT, 4,plaquecoldflt,ibxcolLum);

 Y0 = ptibMaxT->ymax;

#define chBUTSHF 	10

butgrp gr1( X0+20, Y0+16, 46, 18, VERT);
  pbutHeat1 = new indbutton("Heater",'H','h', bpHeat1, 4, SMALL_FONT,4);

 TSInbox<int> *ptibIntens= new TSInbox<int>
	( pbutHeat1->xmax+5,  Y0, "Heat Intns :",
	  5, &heatIntensity,"%d","%d", tibpIntens,SMALL_FONT, 4,plaquecoldflt,ibxcolLum);

_Indicator	_indN1(
		ptibMaxT->xmax, Y0,FIXED,"N",
		5,"%d",	// width of disp in chars,format
		UNFRAMED,procNULL,
		0,1,		//font and size of number
		SMALL_FONT,4,	//font and size of title
		plaquecoldflt,LUMind);

 indN1=&_indN1;

int axmax=ptibStep->xmax;
	//---------------- Buttons ------

butgrp gr2( X0+chBUTSHF,_indN1.ymax+6,(axmax-X0-2*chBUTSHF)>>1,20);
  button butStop("stoP measurement",'P','p',bpStopTdep,SMALL_FONT,4);
  button butStart("Start measurement",'S','s',bpStartTdep,SMALL_FONT,4);

Tdependance->ChangeSize(axmax-X0,butStart.ymax-Tdependance->y0+chBUTSHF);// size of board

	//---------------- Paint whole board
Tdependance->Paint();

ptibMinT->Paint();
ptibMaxT->Paint();
ptibStep->Paint();
ptibIntens->Paint();
_indN1.Paint();

ptibMinT->Refresh();
ptibMaxT->Refresh();
ptibStep->Refresh();
ptibIntens->Refresh();


gr1.Paint();
gr2.Paint();

bsTdep.NextButton();
do
  bsTdep.Loop(TdepBackgr);
while(measInProgress);

Tdependance->Remove();
Tdependance->MkActive();
object::RepaintScr();

delete ptibMinT;
delete ptibMaxT;
delete ptibStep;
delete ptibIntens;

}//--------- bpTdep(void)

		//------ T-DEPENDANCE BUTTON PROCs ----



/*
//------------------------------------ N -----
void far  bpNTdep(void)
{
Inbox EnterN(maxx>>2,maxy>>2,POPUP,"Enter N",40/*size of box*/);
 EnterN.Paint();
 do
 {
  EnterN.cls();
  EnterN.Put("Number of samples =",1);
 }while ( !( EnterN.Scanf("%d",&N1) ) );
 EnterN.Remove();
 indN1->cls();indN1->Put(N1);
}
*/
//------------------------------------ START -----
void far  bpStartTdep(void)
{
if (!measInProgress)
 {
  statusTdep=0;	// start backgr measurement
  _maxT=maxT;
  _minT=minT;
 }
}

//------------------------------------ STOP -----
void far  bpStopTdep(void)
{
if (measInProgress)
 {statusTdep=10;}	// switch backgr measurement in stop mode
}
//+++++++++++++++++++++++++++++++++++++++++++++++++++++
//------------------------------ T-DEPENDANCE GRAPH -----

void far  bpTdepGraph(void)
{
float Temp0,Temp1;
float a10,a11,b10,b11;

 if ( (dat = fopen(nameTdepDat,"rt")) == NULL )
   DisplayErrorMessage("No measurement has been made yet");
 else
 {
  find_ch('=');
  fscanf(dat,"%lf",&minT);
  find_ch('=');
  fscanf(dat,"%lf",&maxT);
  find_ch('=');
  fscanf(dat,"%lf",&step);
  find_ch('@');

 Graph<float,float>  grTdep(
	x0s,y0s,PERM,nameTdepDat,
	15,12,	/* number of x & y div.			*/
	25,20,	/* number of pixels in every div.	*/

	minT,-2.5,	/* values of x,y at origin	*/
	(maxT-minT)/15.,5./12.,	/* values of x,y div.		*/
					  // Hereafter defaults are used
	procDummy,
	"Temperature","A1(red) B1(yellow)",	/* text on the axises*/
	"%.1f","%.2f"); 	        /* format of values on divisions*/

  grTdep.Paint();
  while ( fscanf(dat,"%f%lf%lf",&Temp0,&a1,&b1) != EOF );
  grTdep.PutDot(Temp0,a10,RED);
  grTdep.PutDot(Temp0,b10,YELLOW);
  while ( fscanf(dat,"%f%f%f",&Temp1,&a11,&b11)!=EOF )
  {
   grTdep.PutLine(Temp0,a10,Temp1,a11,RED);
   grTdep.PutLine(Temp0,b10,Temp1,b11,YELLOW);
   a10=a11; b10=b11;
   Temp0=Temp1;
   }
  fclose(dat);
  getch();
  grTdep.Remove();
  }//-- else
}//--------------- END of bpTdepGraph(void) ---------
