//
//  VIRTUAL PANELS * GRAPHIC USER UNTERFACE FOR LABORATORY WORKS
//
//	VPBASE.H : common def & functions,
//		   base classes: plaque,display,object
//
//
//                       |	 Written by O.Rasizade
//    declarations       | 	  Sept 1992,1993
//                       |
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

#ifndef __cplusplus
#error Must use C++
#endif

#ifndef __VPBASE_H
#define __VPBASE_H


#define CLIP_ON  1		/* activates clipping in viewport */
#define CLIP_OFF 0		/* deactivates clipping in viewport */

#define FRAMED   1		// to draw frame around display or not
#define UNFRAMED 0

#define ON  1
#define OFF 0

#define	 SPACING	3	// for vert. text.
#define  SHADWIDTH	2	// for plaque.
#define  BOXFRWD	2	// width of frame of IN,OUT text boxes

#define  VERT	1		// for butgr direction of buttons row
#define  HORIZ  0

#define  EGAVGA 1	//for InitGraphMode, forces to link VGA driver
			//into exe file
#define CNFG_FILE_KEY  "LABGUI_CNF" // key to define config file.
				    // must be at start of file with term. 0
#define KEYLEN		11          // length of keyword with term. 0

	//------------- STATUS OF CONTROLS ------

#define	CRL_ACTIVE	2	// hihglighted
#define CRL_ENABLED     1
#define CRL_DISABLED    0       // grayed
#define CRL_HLDISABLED  3       // hihglight grayed

	//--------- STATUS OF CONSOLE (ConStatus flags) -----

#define  KBD_HIT	1
#define  KBD_CLRHIT	0xFFFE

	//-------------- Global variables --------------
extern int maxx,maxy,maxxx,maxyy;	//max and min of screen
extern int x0s,y0s,xmaxs,ymaxs;		// size and
extern int xx0s,yy0s,xxmaxs,yymaxs;
extern int fillptrn,fillcolor;		// fill style of object drag area
extern float xas,yas;			// aspect ratios
extern int xxspacing,yyspacing;		// versatile spacing between text lines

extern int menustatus;		// status of menu system:
				//   if 0 then menu system is not installed
				//      1 then menu system has been installed

	 //----------------------------------------------

#define max(a,b)    (((a) > (b)) ? (a) : (b))
#define  round(V)      (((V)>=0)?((V)+.5):((V)-.5))

#define  maxviewport 	setviewport(0,0,maxxx,maxyy,CLIP_ON)
#define beep	       putch(7)

void far lgErrExit(char *msg);
inline void far procDummy(void) {}
inline void far procNULL(void) { lgErrExit("procNULL:Illegal object proc call");}

	// object types:fixed 	  no list  no drag
	//		permanent    list     drag
	//		popup     no list     drag
enum objtype {FIXED,PERM,POPUP};


//+++++++++++ LABGUI FUNCTIONS ++++++++++++

void  InitAndCopyright
			(char *copyright,
			int fillcolor=MAGENTA,int fillptrn=CLOSE_DOT_FILL,
			int grdrv=0, char *bgipath="..\\bgi");
void  QuitVirtualPanels(void); // restore preceding CRT
//--------------------------- Implementation in VPCOPYRT.CPP module
void  InitVirtualPanels(int _x0s=0,int _y0s=0,int _xmaxs=0,int _ymaxs=0,
			int _fillcolor=MAGENTA,int _fillptrn=CLOSE_DOT_FILL);
	// if _xmaxs(_ymaxs) is 0 then dragging region is set to whole screen

//------------------------------------------------------------
// transforms length in pixels in accordance with aspect ratio
//------------------------------------------------------------
int   xx__x(int xpix);	//x to aspect x
int   yy__y(int ypix);
int   x__xx(int xpix);	//aspect x to x
int   y__yy(int ypix);

//-------------------------------------------------------------
// 			set Dragging Area
//-------------------------------------------------------------

void  SetDragAreaX0( int x0);
void  SetDragAreaY0( int y0);
void  SetDragAreaXmax( int xmax);
void  SetDragAreaYmax( int ymax);

//+++++++++++ General Purpose Functions ++++++++++++

#ifdef __cplusplus
extern "C" {
#endif
void  InitGraphMode(int grdrv=0,char *bgipath="..\\bgi");
int  gprintf( int xloc, int yloc, char *fmt, ... );
int  gprintf_n( int *xloc, int *yloc, char *fmt, ... );
int  WidthOfTemplate(char *format,...);
#ifdef __cplusplus
}
#endif

//----------------------------------------------------
//			 CLASSES
//----------------------------------------------------

//++++++++++++++ CLASS   << PLAQUE >>  +++++++++++++++

struct plaquecolors
	{COLORS
	surface ,
	shadow ,
	ltnd;
	};
const plaquecolors plaquecoldflt={
			 LIGHTGRAY,	// surface
			 DARKGRAY,	// shadow
			 WHITE	// ltnd
			};
class plaque
{
 protected:
	plaquecolors plqcolors;
	int xxlen,yylen;	// versatile size

 public:
	// Constructors
   plaque (plaquecolors plaquecolconfig=plaquecoldflt)
				 { plqcolors=plaquecolconfig;}
   plaque (int xlength,int ylength,
		    plaquecolors plaquecolconfig=plaquecoldflt)
		  {
		   xxlen=xx__x(xlength); yylen=yy__y(ylength);
		   plqcolors=plaquecolconfig;
		   }
 virtual void   PaintAt(int x0,int y0);//Draws plaque on the screen
};//--------------- END of class PLAQE ------------------

//+++++++++++++++++++++++++++++++++++++++++++++++++++++
//++++++++++++++ CLASS   << DISPLAY >>  +++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++

// Note that display may be created on the plaque, so
// it uses plaques colors

// Default
const COLORS dispcoldflt= BLACK;

class display : public plaque
{
  void  swapcolors(COLORS dispcolconfig)
       {
	COLORS temp;
	temp=plqcolors.shadow; plqcolors.shadow=plqcolors.ltnd;
	plqcolors.ltnd=temp; plqcolors.surface=dispcolconfig;
       }
 protected:

  int xx0p,yy0p,xxmaxp,yymaxp;	// viewport of display "paper"
  int xx0pd,yy0pd;              // origin of "paper" relative to frame
  int frame;			// boolean: 0-no frame should be painted

  //-------------------------- Constructors --
    display (int _frame=FRAMED,plaquecolors plaquecolconfig=plaquecoldflt,
		   COLORS dispcolconfig=dispcoldflt) :
			plaque(plaquecolconfig)

			{ swapcolors(dispcolconfig);frame=_frame;}

    display (int xlen,int ylen,int _frame=FRAMED,
		   plaquecolors plaquecolconfig=plaquecoldflt,
				COLORS dispcolconfig=dispcoldflt) :
			plaque(xlen,ylen,plaquecolconfig)
	{swapcolors(dispcolconfig);frame=_frame;}

 virtual void  PaintAt(int x0,int y0);

public:
 virtual	void  cls();

};//++++++++++++++ END of class DISPLAY +++++++++++++++++++++

//++++++++++++++++++++++++++++++++++++++++++++++++++++
//++++++++++++++ CLASS   << OBJECT >>  +++++++++++++++
//++++++++++++++++++++++++++++++++++++++++++++++++++++

class object
{
 friend butsystem;

	int handle;
	void far *savebuf;	// ptr to underlying image storage

 static void  XorRect(void);

protected:
	// Stack of Objects : list of POPUP and on the screen PERM objects
 static object  *actobj;	// ptr to active object-top of list
 static object  *btmobj;	// ptr to first object-bottom of list
	// connected list of all Objects
 static object  *fstobj;	// ptr to first  object
 static object  *lastobj;	// ptr to last object

  char *title;
  int  titlefont,titlefontsize;
		// STATUS of object


  objtype type;		// may be FIXED,PERM,POPUP
  void (far *proc)(void);	//paint procedure
	      // ptrs for the Stack of Objects - list of POPUP and
	      //				on the screen PERM objects
  object *prev,*next;
	     // ptrs for the List of all Objects
  object *prevobj,*nextobj;

// Protected METHODS
 static object *  GetObject( int _handle);
	// returns ptr ot object class if OK
	//         or NULL if there is no object with _handle
    void  Save(void); //save underlying image
 static void  Drag(void);
 static void  Delete(void);


public:
	int x0,y0,xmax,ymax;	// location of object
	int xx0,yy0,xxmax,yymax;// versatile location of object
	unsigned OnScreen;
	unsigned Active;

	// Constructor
   object(int _x0,int _y0,
		objtype _type,char *_title,
		void (far *_proc)(),int _titlefont,int _titlefontsize);
	// Destructor
   ~object(void);

static  void  RepaintScr(void);
static  void  NextPERM(void);
virtual void  Paint(void)=0; // paint object
virtual	void  MovetoXY(int _x0,int _y0);
	void  GetXY(int *_x0,int *_y0,int *_xmax,int *_ymax)
		{*_x0=x0;*_y0=y0;*_xmax=xmax;*_ymax=ymax;}
	void  GetXXYY(int *_xx0,int *_yy0,int *_xxmax,int *_yymax)
		{*_xx0=xx0;*_yy0=yy0;*_xxmax=xxmax;*_yymax=yymax;}
	void  Remove(void); //remove POPUP object from screen
				  //and restore underlying image
	void  MkActive(void);	  //move obj on top of list

 static int   LoadCnfg(char *name);//Load PERM or POPUP objs last configuration
/* returns:
 *	 0 if OK,
 *	-1 if   name file doesn't exist
 *	-2	or no PERM or POPUP objects currently exit
 *	-3	or keyword doesn't match
 */
 static int   SaveCnfg(char *name);//Save PERM or POPUP objs last configuration ------
// returns:
//	 0 if OK,
//	-1 if cannot write to or create configuration file
//	-2 if no PERM or POPUP objects currently exit
};
//--------------- END of class OBJECT ------------------

#endif // __VPBASE_H