//
//  VIRTUAL PANELS * GRAPHIC USER UNTERFACE FOR LABORATORY WORKS
//
//		VPBUTT.H : CLASSes: tabstop, butgrp,
//				    button,  indbutton
//				    butsystem
//
//                       |	 Written by O.Rasizade
//    declarations       | 	  Sept 1992, 1993
//                       |
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

#ifndef __cplusplus
#error Must use C++ 
#endif

#ifndef __VPBUTT_H
#define __VPBUTT_H

#if !defined(__VPLED_H)
#include <vpled.h>
#endif

#define MASTER		1	// master of Dragging Area

// MESSAGES ADDRESSED TO KbdLoop(). Default is 0 no message
#define MSG_EXIT	1
#define MSG_NEXTTABSTOP	2
#define MSG_PREVTABSTOP	3

class button;

//++++++++++++++++++++++++++++++++++++++++++++++
//++++++     COLORS   ++++++++++++++++++++++++++
//++++++++++++++++++++++++++++++++++++++++++++++

//--------------------- FOR BUTTON -----

struct buttoncolors {COLORS
			disabledtext,
			hldisabltext,	// color of highlighted disabled text
			enabledtext,
			activetext;
		      };
//------------------------------ Default button colors
const buttoncolors buttextdflt={
			      BLACK,
			      LIGHTGRAY,
			      GREEN,
			      LIGHTGREEN
			      };
const plaquecolors butcoldflt={
			  DARKGRAY,
			  BLACK,
			  LIGHTGRAY
			  };
//------------------------------ Quit button colors
const buttoncolors quittexcol={
			BLACK,		// disabled text
			DARKGRAY,	// ighlighted disabled text
			LIGHTGRAY,	// enabled text
			WHITE		// active text
		      };

const plaquecolors quitbutcol={
			 RED,		// PlaqeColor
			 BLACK,		// shadow
			 LIGHTGRAY	// ltnd
			};

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//++++++++++++++ CLASS   << tabstop >>  +++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
class tabstop
{
friend butsystem;

protected:

 tabstop *prev,*next;

public:
  tabstop(void);

 virtual void  Deactivate(void)=0;
 virtual void  Activate(void)=0;
};

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//++++++++++++++ CLASS   << BUTGRP >>  ++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

class butgrp: public tabstop
{
 friend button;
 friend indbutton;

 static int x0,y0;	// start point for buttons, incremented by Paint routines
	 int direction; 	// may be VERT or HORIZ
	 int distance;          // between buttons
	 int xlen,ylen;
	 button *actbut,*fstbut;
 static butgrp *actgrp;

 virtual void  Deactivate(void);
 virtual void  Activate(void);

 public:

 butgrp(int _x0,int _y0,int _xlen,int _ylen,
					int _direction=HORIZ,int _distance=0);
	void  Paint(void); // paint whole group of buttons

	void  ShiftToX(int x) {x0=x;}
	void  ShiftToY(int y) {y0=y;}
	void  ShiftX(int x) {x0+=x;}
	void  ShiftY(int y) {y0+=y;}
};

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//++++++++++++++ CLASS   << BUTTON >>  ++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

class button : public plaque
{
 friend butgrp;
 friend butsystem;
 friend indbutton;

 char *title;
 int titlefont,titlefontsize;
 void (far *proc)(void);// procedure attached to button
 char asc0,asc1;	// key - extended ASCII of kbd shortcut
 int status;// can be CRL_ACTIVE, CRL_ENABLED, CRL_DISABLED or CRL_HLDISABLED
 buttoncolors buttextcolors;

  button *bnext;  // used to make list
  button *bprev;

	void  printext(void);
	void  Activate(void);
	void  Deactivate(void);
	void  Press(void);
	void  Release(void);

public:

 int x0,y0,xmax,ymax;	// location of button
 int xx0,yy0,xxmax,yymax;// versatile location of button

//------------ Constructor  ALL SIZES IN VGA PIXELS ------------

button (
		char *_title,               // text on button
		char ascii0,char ascii1,    // kbd shortcut to activate button
		void (far *procedure)(void),// procedure connected with button
		int txfont=0,int txsize=1,  // font style and size of text
		buttoncolors buttextcnfg=buttextdflt, //colors of textl
		plaquecolors butcol=butcoldflt);      //colors of button

	void  Enable(void)
			{ status=CRL_ENABLED;}
	void  Disable(void)
			 { status=CRL_DISABLED;}
	int   GetStatus(void)
			{ return status; }

virtual	void  Paint(void);
};

//++++++++++++++ END of class BUTTON +++++++++++++++++++++


//+++++++++++++++++++++++++++++++++++++++++++++++++
//++++++++++ CLASS   << INDBUTTON >>  +++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++

#define INDOFFSET  5

//--------------------- Class declaration  --

class indbutton: public button, public LED
{

public:

  //----- Constructor ------- All coord. and sizes in VGA pixels ----
 indbutton(
		char *_title,               // text on button
		char ascii0,char ascii1,    // kbd shortcut to activate button
		void (far *procedure)(void),    // procedure connected with button
			// Hereafter are defaults
		int _indradius=4,	    // radius of indicator
		int txfont=0,int txsize=1,  // font style and size of text
		LEDcolors _indcol=redLED,	//colors of LED
		buttoncolors buttextcnfg=buttextdflt,	//colors of textl
		plaquecolors butcol=butcoldflt		//colors of button
		);

virtual	void  Paint(void);

};//++++++++++++++ END of class indbutton +++++++++++++++++++


//+++++++++++++++++++++++++++++++++++++++++++++++++
//++++++++++ CLASS   << BUTSYSTEM >>  +++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++

//--------------------- Class declaration  --

class butsystem
{
friend tabstop;
friend butgrp;
friend button;
friend indbutton;


 static butsystem *actbutsys;

   butsystem *oldbutsys;	// storage
   int master;		// if TRUE then is the master of Dragging Area
   int butstatus;	// status of button system:
			//   if 0 then button system is not installed
			//      1 then button system has been installed
   tabstop *actgrp;	// ptr to active tabstop
   tabstop *fstgrp;	//        first  tabstop

   button *actbut;	// ptr to active button
   button *fstbut; 	//        first button

   int      message;	// message box for KbdLoop

void  Process(void);

public:

 unsigned int   ConStatus;	// status of kbd and mouse
 unsigned char  key0;		// ascii codes of last keystroke
 unsigned char  key1;

  //----- Constructor
 butsystem(int _master = 0); // Is not master by default

 //------ Destructor
 ~butsystem(void)
{
 actbutsys = oldbutsys;
}

static void  SendMessage( int messg); // to Loop()

 void  NextTabStop(void);	// Increase active tabstop
 void  PrevTabStop(void);	// Decrease active tabstop
 void  NextButton(void);	// Increase active button
 void  PrevButton(void);	// Decrease active button
 void  Loop(void (far *bkgrproc)(void));

};//++++++++++++++ END of class butsystem+++++++++++++++++++


#endif // __VPBUTT_H