//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
//  		  HERE IS DEMO PROGRAM
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#include "vphead.h"	// must be included first
#pragma hdrstop

#include "vpbase.h"
#include "vpboard.h"
#include "vpoutbox.h"
#include "vpinbox.h"
#include "vpindic.h"
#include "vpgraph.h"
#include "vpbutt.h"


#define	  BGIPATH	"..\\bgi"
#define NPOINTS  100
#define CNF_NAME	"vpdemo.cnf"

  int far EGAVGA_driver_far[1];
//+++++++++++++++++++++++++++++++++++++++++
//++++++   GLOBAL VARIABLES +++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++

float Temp=-77.02,Volt=1.64;
float afsignal[ NPOINTS ];

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++
//++++++	 COLOR CONFUGURATION 		+++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++


plaquecolors framecolconfig={
			 LIGHTGRAY,	// PlaqeColor
			 DARKGRAY,	// shadow
			 WHITE	// ltnd
			};


int dispcolconfig= GREEN;

const graphcolors OscColors={
		BLUE,		//paper color
		LIGHTGREEN,	//Ink color
		LIGHTBLUE,	//Grid2Col
		RED,		//titlecolor
		BLACK,		//texcolor
		YELLOW		//divvalcolor
		};

//+++++++++++++++ END OF COLOR CONFIGURATION +++++++++++++++++
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//++++++++++++++++ REFERENCES TO OBJECTS ++++++++++++++++

Graph<double,double> *grOsc,*grFourierLOG, *grPickup;
Graph<float,float>   *grFourierBar;

butsystem *pbsMain;
Indicator<float>  *indVolt,*indTemp;
_Indicator *Clock,*indInfo;
Outbox *obxHelp;
Board *brdEnter;
indbutton *pib1,*pib2,*pib3;
indbutton *pi_b1,*pi_b2,*pi_b3;
LED *ledind;

//++++++++++++++++++++ FUNCTIONS +++++++++++++++++++++++++++
float ph;
double far signal(double x)
{
 float xa,y;
 xa=fabs(x);
 if(xa<=.5) y=1.-6*xa*xa*(1-xa);
     else if (xa>=.5 && xa<=1.) y=2*pow(1-xa,3);
	  else y=0.;
 y*=sin(M_PI*x)/(M_PI*x);
 return y;
 }
double far fsignal(double x)
{
 return .75*pow(sin(M_PI*x/2)/(M_PI*x/2),2);
 }

double far sinsignal(double x)
{ return sin(5*x+ph);		//sin(200*(x+ph))*sin(20*(x+ph));
 }

//+++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++ PROCEDURES ATTACHED TO BUTTONS ++++++++++++
//+++++++++     AND PAINT PROCEDURES       ++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++
int r=0,g=0,b=0;
EGA_COLORS  colPal=EGA_LIGHTGRAY;

void far BackgrProc(void)	// user defined background routine
{ }
//-------------------------*
// Buttons with indicators |
//-------------------------*
void far bpib1(void) {pib1->Invert();}
void far bpib2(void) {pib2->Invert();}
void far bpib3(void) {pib3->Invert();}

void far bpi_b1(void) {pi_b1->Invert();}
void far bpi_b2(void) {pi_b2->Invert();}
void far bpi_b3(void) {pi_b3->Invert();}

//-----------------------------------
//---------- Palette choosing procs
//-----------------------------------

Indicator<int> *indRed, *indGreen, *indBlue;

void far bpRedInc()
{ r=(++r) & 0x3f; setrgbpalette(colPal,r,g,b); indRed->Put(r);}

void far bpRedDec()
{ r=(--r) & 0x3f; setrgbpalette(colPal,r,g,b); indRed->Put(r);}

void far bpGrnInc()
{ g=(++g) & 0x3f; setrgbpalette(colPal,r,g,b); indGreen->Put(g);}

void far bpGrnDec()
{ g=(--g) & 0x3f; setrgbpalette(colPal,r,g,b); indGreen->Put(g);}

void far bpBlueInc()
{ b=(++b) & 0x3f; setrgbpalette(colPal,r,g,b); indBlue->Put(b);}

void far bpBlueDec()
{ b=(--b) & 0x3f; setrgbpalette(colPal,r,g,b); indBlue->Put(b);}

void far bpPalNextCol()
{ switch (colPal)
  { case EGA_LIGHTGRAY: {colPal=EGA_WHITE;break;}
    case EGA_WHITE    : {colPal=EGA_DARKGRAY;break;}
    case EGA_DARKGRAY : {colPal=EGA_LIGHTGRAY;break;}
  }
}

void far bpPalPrevCol()
{ switch (colPal)
  { case EGA_LIGHTGRAY: {colPal=EGA_DARKGRAY;break;}
    case EGA_WHITE    : {colPal=EGA_LIGHTGRAY;break;}
    case EGA_DARKGRAY : {colPal=EGA_WHITE;break;}
  }
}
//----------------------------

void far bpPalette()
{
#define BLXPal 82
#define BLYPal 22

	//-------------------- COLOR setting for indicators
const indicatorcolors LCDred={
		       RED,	// color of title
		       DARKGRAY,// foreground color
		       YELLOW	// background color
		       };
const indicatorcolors LCDgreen={
		       GREEN,	// color of title
		       DARKGRAY,// foreground color
		       YELLOW	// background color
		       };

int ax0=maxxx>>2,ay0=maxyy>>2;
int ax0t=ax0+20,ay0t=ay0+50;	// temporary storage

butsystem  bsPalette;	// NEW BUTTON SYSTEM

indRed = new Indicator<int> (
		ax0t,ay0t,
		FIXED,
		"Red",		// title
		8, &r,"%5u",	// width of disp in chars,format
		UNFRAMED,
		procNULL,
		0,1,		//font and size of number
		0,1,		//font and size of title
		framecolconfig,LCDred);

int ix0,iy0,ixmax,iymax;	// size of indicator
 indRed->GetXY(&ix0,&iy0,&ixmax,&iymax);

indGreen = new Indicator<int>(
		ixmax+20,ay0t,
		FIXED,
		"Green",	// title
		8, &g,"%5u",	// width of disp in chars,format
		UNFRAMED,
		procNULL,
		0,1,		//font and size of number
		0,1,		//font and size of title
		framecolconfig,LCDgreen);

indBlue = new Indicator<int>(
		indGreen->xmax+20,ay0t,
		FIXED,
		"Blue",		// title
		8, &b,"%5u",	// width of disp in chars,format
		UNFRAMED,
		procNULL,
		0,1,		//font and size of number
		0,1,		//font and size of title
		framecolconfig,LCDbright);

	//---------------- Buttons ------
int  bxsz=ixmax-ix0-4>>1;
butgrp gr1(ix0,iymax+2,bxsz,20);
  button butRedInc("R=+",'r','R',bpRedInc);
  button butRedDec("T=-",'t','T',bpRedDec);
 gr1.ShiftToX(ixmax+20);
  button butGrnInc("G=+",'g','G',bpGrnInc);
  button butGrnDec("H=-",'h','H',bpGrnDec);
 gr1.ShiftToX(indBlue->x0);
  button butBlueInc("B=+",'b','B',bpBlueInc);
  button butBlueDec("N=-",'n','N',bpBlueDec);

 bxsz=3*bxsz+20;
int  brdszx=x__xx(indBlue->xxmax-ax0)+20;
butgrp gr2(ix0,butRedInc.ymax+4,bxsz,25,HORIZ,brdszx-2*(ix0-ax0+bxsz));
 button butPalNextCol("Z=Next Color",'z','Z',bpPalNextCol);
 button butPalPrevCol("X=Previous Color",'x','X',bpPalPrevCol);

Board brdPalette(
	     x__xx(ax0),y__yy(ay0),	// left top coord
	     POPUP,			// may be FIXED,PERM,POPUP
	     "Choose Palette for VGA", 	// title
	     brdszx,// size of board
	     y__yy(butPalPrevCol.yymax-ay0+20),
	     procNULL,
	     TRIPLEX_FONT,3);	// title FONT

	//---------------- Paint whole board
 brdPalette.Paint();

 indRed->Paint();
 indGreen->Paint();
 indBlue->Paint();

 indRed->Put(r);
 indGreen->Put(g);
 indBlue->Put(b);

 gr1.Paint();
 gr2.Paint();

 bsPalette.NextTabStop();
 bsPalette.Loop(BackgrProc);

 delete indRed;
 delete indGreen;
 delete indBlue;

 brdPalette.Remove();
}
//-----------------------------------
void far ppPickup(void)
{
 grPickup->Paint();
 grPickup->ShowCurve(NPOINTS,signal);
}

void far bpPickup(void)
{
 ppPickup();
 grPickup->MkActive();
}
//-------------------------------

void far ppFourierLOG(void)
{
grFourierLOG->Paint();
grFourierLOG->ShowCurve(NPOINTS,fsignal);
}

void far bpFourierLOG(void)
{
 ppFourierLOG();
 grFourierLOG->MkActive();
}
//-------------------------------

void far ppFourierBar(void)
{
grFourierBar->Paint();
grFourierBar->ShowHistogram( NPOINTS, -8., 16./(NPOINTS-1), afsignal, LIGHTGREEN);
}

void far bpFourierBar(void)
{
 ppFourierBar();
 grFourierBar->MkActive();
}
//-------------------------------

void far bpQuit(void)
{
 object::SaveCnfg(CNF_NAME);
 QuitVirtualPanels();
 exit(0);
}
//--------------------------------

int sx=0;
void far bpOsc(void)	// popup graph
{
 grOsc->Paint();
 grOsc->MkActive();
 ph=0.;
 do{
   ph-=.5;
   grOsc->ShowCurve(NPOINTS,sinsignal);
   grOsc->HideCurve(NPOINTS,sinsignal);
   }while(!kbhit());
 grOsc->Remove();
}
//---------------------------
void far ppTemp()
{                            // perm ind
 indTemp->Paint();
 indTemp->Put(Temp);
}

void far bpTemp()
{
 ppTemp();
 indTemp->MkActive();
}
//---------------------------
void far bpVolt()
{                            // popup indicator
 indVolt->Paint();
 indVolt->Put(Volt);
 indVolt->MkActive();
 while(!kbhit());
 indVolt->Remove();
 }
//-----------------------------

void far bpEnter()
{                            // popup
butsystem bsEnter;

TSInbox<float>				  // size of box
 tibTemp( brdEnter->x0, brdEnter->y0p,"Temperature:", 12, &Temp, "%f", "%.2f");

TSInbox<float>
  tibVolt( brdEnter->x0, tibTemp.ymax, "Voltage:", 12, &Volt,"%f","%.2f");

butgrp grpv(tibVolt.xmax+26, brdEnter->y0p+10, 100, 16, VERT, 2);
 indbutton i_b1("Heater",'\x0','\x0',bpi_b1);
 indbutton i_b2("Ventilation",'\x0','\x0',bpi_b2);
 indbutton i_b3("SaveOnExit",'\x0','\x0',bpi_b3);

 i_b2.Disable();
pi_b1=&i_b1;pi_b2=&i_b2;pi_b3=&i_b3;

 brdEnter->ChangeSize( i_b1.xmax - tibVolt.x0 +10,
		      tibVolt.ymax - brdEnter->y0);

 brdEnter->Paint();
 tibTemp.Paint();
 tibVolt.Paint();
 tibTemp.Refresh();
 tibVolt.Refresh();
 grpv.Paint();

 bsEnter.NextButton();
 bsEnter.Loop( procDummy);

 brdEnter->MkActive();
 brdEnter->Remove();
 if( indTemp->OnScreen )
	indTemp->Put(Temp);	// refresh
}

//---------------------------- BP HELP -----
void far bpHelp()
{                            // popup output box
#define	hN  8	// number of rows of help text
int i;
  //------------------- HELP text
char *txt[2][hN]=
 {
  {"Alt-F3","Ctrl-F5","F6","Left,Right,Up,Down","Ctrl-Left,Right,Up,Down",
    "Tab","Shift-Tab","Esc"},
  {"close window", "start dragging object", "switch between objects",
   "quick drag", "slow drag",
   "go to next button group", "go to prev. button group",
   "quit"}
  };

 obxHelp->Paint();
 obxHelp->MkActive();
		// hilight text output
 for (i=0;i<hN;i++) obxHelp->Printfn(1,txt[0][i]);

 obxHelp->GotoXY(0,0);
 obxHelp->SetTextJustify(RIGHT_TEXT);	// normal text output
 for (i=0;i<hN;i++) obxHelp->Putn(txt[1][i]);

 obxHelp->GotoXY(0,-1); 	// put cursor at bottom of box
 obxHelp->SetTextJustify(CENTER_TEXT);
 obxHelp->SetTextColor(LIGHTGREEN);
 obxHelp->Put("Press any key...");
 obxHelp->SetTextColor(WHITE);
 getch();

 obxHelp->cls();
int x,y; obxHelp->GetXY(&x,&y);
 obxHelp->Printfn(0,"x=%d",x);
 obxHelp->Printf(0,"y=%d",y);

 getch();
 obxHelp->Remove();
 }

//++++++++++++++++++ PRINT ABOUT ++++++++++++++++++++

#define LF_CR   gprintf_n(&xloc,&yloc,"")

void prnextr(int *xloc,int *yloc,char *text)
{
 setcolor(WHITE);
 gprintf(*xloc-1,*yloc-1,text);
 setcolor(DARKGRAY);
  gprintf(*xloc+1,*yloc+1,text);
 setcolor(LIGHTGRAY);
  gprintf_n(xloc,yloc,text);
}


void PrintAbout(int tfont)
{
int axl=maxxx>>1,ayl=maxyy>>1;
int ax0=axl>>1,ay0=ayl>>1;
int xloc=ax0,yloc=0;
Board about(
	x__xx(ax0),y__yy(ay0),	// left top coord where to paint the board
	POPUP,			// may be FIXED,PERM,POPUP
	"",	     	 	// title
	x__xx(axl),y__yy(ayl),		// size of board
	procNULL,tfont,4);	// set font for first row

 about.Paint(); // is put here to release far heap before font

 setviewport(ax0,ay0,3*ax0,3*ay0,CLIP_OFF);
 settextjustify(CENTER_TEXT,TOP_TEXT);
 LF_CR;
  prnextr(&xloc,&yloc,"Virtual Panels");
 settextstyle(tfont,HORIZ_DIR,3);
  prnextr(&xloc,&yloc,"for lab works");
 settextstyle(tfont,HORIZ_DIR,2);
  prnextr(&xloc,&yloc,"version 1.0");
 settextstyle(0,HORIZ_DIR,1);
 yloc+=10*yyspacing;
 setcolor(LIGHTGREEN);
  gprintf_n(&xloc,&yloc,"by O.Rasizade");
  gprintf_n(&xloc,&yloc,"");
  gprintf_n(&xloc,&yloc,"written  1993");

 getch();
 about.Remove();
}
//++++++++++++++++++++++ BACKGROUND PROCEDURE +++++++++++++++++++
void far procClock(void)
{
struct  time t;
static int sec;

 if ( (pbsMain->ConStatus & KBD_HIT) == 1)
   goto info;
 gettime(&t);
 if (sec!=t.ti_sec)
  { Clock->Put(t.ti_hour, t.ti_min, t.ti_sec);
    sec=t.ti_sec;
    ledind->Invert();

info:
 indInfo->Paint();
 indInfo->Put(pbsMain->key0,pbsMain->key1,pbsMain->ConStatus);

  }
}
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//++++++++++++++++++++++++ MAIN+++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++


main()
{
InitAndCopyright("* VirtualPanels Demo * by O.Rasizade, 1993, JINR, Dubna *", MAGENTA, CLOSE_DOT_FILL);
PrintAbout(TRIPLEX_FONT);

butsystem bsMain( MASTER );

pbsMain = &bsMain;

float dx = 16./ (NPOINTS-1) ;

for ( int i=0; i < NPOINTS; i++)
	afsignal[i] = fsignal( -8.+ i*dx );

Graph<double,double>  _grPickup( x0s,y0s, PERM, "Pickup coil voltage",
				8,4,	/* number of x & y div.			*/
				35,35,	/* number of pixels at every div.	*/
				-.8,0.,	/* values of x,y at origin	*/
				.8,1.,	/* max values of x,y		*/
				ppPickup,
				"Time (ms)","Signal (mV)",	/* text on the axises		*/
				"%.1f","%.1f", 	        /* format of values on divisions*/
				LIN, LIN, FRAMED,
				TRIPLEX_FONT,2,	//title font and fontsize
				TRIPLEX_FONT,2);	//text font and fontsize

Graph<double,double>	_grOsc( x0s, y0s, POPUP, "Osciloscope",
				5,4,	/* number of x & y div.			*/
				30,30,	/* number of pixels between tics*/
				-1.,-1.,	/* values of x,y at origin	*/
				1.5,1.,	/* max values of x,y 		*/
				bpOsc,
				"","","","", LIN, LIN, UNFRAMED,
				0,1, 0,1, 0,1,
				OscColors,framecolconfig);


Graph<double,double>  _grFourierLOG( x0s,y0s,PERM, "Fourier transform",
			3, 4,	// number of x & y div.
			90, 60,	/* number of pixels 	*/
			-1, -4,	/* values of x,y at origin	*/
			0.,0.,	/* max values of x,y	*/
			ppFourierLOG,
			"Frequency (hz)","Amplitude",	/* text on the axises		*/
			"%.1f","%.1f",	        /* format of values on divisions*/
			LOG, LOG );

Graph<float,float>   _grFourierBar( x0s,y0s, PERM, "Fourier transform",
				16, 5,	/* number of x & y div.			*/
				20, 30,	/* number of pixels in every div.	*/
				-8., 0.,/* values of x,y at origin	*/
				8.,1.,	/* max values of x,y 		*/
				ppFourierBar,
				"Frequency (hz)","Amplitude",	/* text on the axises		*/
				"%.1f","%.1f" );/* format of values on divisions*/

grOsc=&_grOsc;
grFourierLOG=&_grFourierLOG;
grFourierBar=&_grFourierBar;
grPickup=&_grPickup;


Indicator<float>
	 _indTemp(
		x0s,y0s,
		PERM,           // type
		"Temperature",	// title
		12, &Temp,"%8.2f\370C",// width of disp in chars,format
		FRAMED,
		ppTemp,
		SANS_SERIF_FONT,4,	//font and size of number
		1,4,			//font and size of title
		framecolconfig,LEDind),

	  _indVolt(
		x0s,y0s,
		POPUP,
		"Voltage" ,		// title
		9, &Volt,"%2.3fmV", 	// width of disp in chars,format
		FRAMED,
		bpVolt,
		SANS_SERIF_FONT,4,//font and size of number
		1,4			//font and size of title
		);

indVolt=&_indVolt;
indTemp=&_indTemp;

obxHelp = new Outbox (
	     maxx>>2,maxy>>2,// left top coord
	     POPUP,			// may be FIXED,PERM,POPUP
	     "Help", 			// title
	     35,10,	// size of board
	     FRAMED,
	     bpHelp,3,4	// title font
	     );

butgrp grp1(3,maxy-26,70,20,HORIZ,2);
 button butQuit("Quit",'Q','q',bpQuit,0,1,quittexcol,quitbutcol);
 button butFourierLOG("fourLOG",'L','l',bpFourierLOG);
 button butFourierBar("fourBar",'B','b',bpFourierBar);
 button butPickup("pickUp",'U','u',bpPickup);
 button butTemp("T \370C",'t','T',bpTemp);
 button butPalette("Palette",'P','p',bpPalette);
 button butHelp("Help",'h','H',bpHelp);


//-------------- Enter Board------------
Board _brdEnter(
     x0s,y0s,//maxx>>2,maxy>>2,
     POPUP,		// may be FIXED,PERM,POPUP
     "Dialog Box",	// title
     0,0,		// size of board
     bpEnter );
brdEnter = &_brdEnter;
//------------------------------ Clock ------------
_Indicator _Clock(
		0,0,
		FIXED,           // type
		"Time",	// title
		8,"%2d:%02d:%02d",// width of disp in chars,format
		UNFRAMED,
		procNULL,
		SANS_SERIF_FONT,1);	//font and size of number
 Clock=&_Clock;

int cxlen2=_Clock.xmax-_Clock.x0+4;
 xxmaxs=maxxx-cxlen2;
 yymaxs=maxyy-30; ymaxs=y__yy(yymaxs);
 _Clock.MovetoXY(2+(xmaxs=x__xx(xxmaxs)),y0s+10);

//------------------------------- Draw control panel with clock

plaque plqControl1(maxx-cxlen2-1,y__yy(29));
plaque plqControl2(cxlen2-1,maxy-y0s);
 plqControl1.PaintAt(0,ymaxs+1);
 plqControl2.PaintAt(xmaxs+1,y0s);
 _Clock.Paint();

butgrp grp2(xmaxs+6,maxy-140,80,40,VERT);
 button butEnter("Enter",'e','E',bpEnter,TRIPLEX_FONT,1);
 button butVolt("mV",'t','T',bpVolt,TRIPLEX_FONT,1);
 button butOsc("Signal",'s','S',bpOsc,TRIPLEX_FONT,1);

//------ BUTTONS with INDICATORS ----

butgrp grph(xmaxs+8,_Clock.ymax+30,(cxlen2>>2),16,HORIZ,0);
 indbutton ib1("ib1",'\x0','\x0',bpib1,5,0,1,greenLED);
 indbutton ib2("ib2",'\x0','\x0',bpib2);
 indbutton ib3("ib3",'\x0','\x0',bpib3,3,0,1,yellowLED);

pib1=&ib1;pib2=&ib2;pib3=&ib3;

 grp1.Paint();
 grp2.Paint();
 grph.Paint();
	//----------- INFO INDICATOR ----------
_Indicator _indInfo(
		maxx>>2,maxy>>2,PERM,"Info",
		25,"key0=%X key1=%X STATUS=%X",
		FRAMED,
		procDummy,
		SMALL_FONT,4,	//font and size of number
		3,3,			//font and size of title
		framecolconfig,LUMind);
indInfo = &_indInfo;

	//--------- LED INDICATOR ------
LED _ledind(xmaxs+30,_Clock.ymax+5, "Ticks",	// Hereafter are defaults
	   4,			// radius of indicator
	   SMALL_FONT, 4 );  	 	// font style and size of title
ledind=&_ledind;
 _ledind.Paint();

 bsMain.NextTabStop();

 object::LoadCnfg(CNF_NAME);
 object::RepaintScr();

 bsMain.Loop(procClock);

 object::SaveCnfg(CNF_NAME);
 delete obxHelp;
 QuitVirtualPanels();
}
//++++++++++++++++++++++++ END OF MAIN ++++++++++++++++++++++++
