//
//  VIRTUAL PANELS * GRAPHIC USER UNTERFACE FOR LABORATORY WORKS
//
//		VPGRAPH.H : CLASS: Graph
//
//                       |	 Written by O.Rasizade
//    declarations       | 	   1993
//                       |
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

#ifndef __cplusplus
#error Must use C++ 
#endif

#ifndef __VPGRAPH_H
#define __VPGRAPH_H


//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//++++++++++++++ CLASS   << _Graph >>  +++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

#define  XNOTCHLENGTH	5	// for graph X axis tic marks
#define  YNOTCHLENGTH	5	// for graph Y axis tic marks.

#define	 LIN	0	// type of scale
#define	 LOG	1

struct graphcolors { COLORS
			Paper,
			Ink,
			Grid,
			Title,
			AxesTitles,
			TicLabels; };

//--------------- Color schemes -------------
const graphcolors WhiteOnCyan={
		CYAN,		//paper color
		WHITE,		//Ink
		LIGHTCYAN,	//Grid2Col
		RED,		//Title
		BLACK,		//AxesTitles
		BLUE 		//TicLabels
		};
const graphcolors YellowOnCyan={
		CYAN,		//paper color
		YELLOW,		//Ink
		LIGHTCYAN,	//Grid2Col
		RED,		//Title
		BLACK,		//AxesTitles
		BLUE 		//TicLabels
		};

const graphcolors GreenOnBlue={
		BLUE,		//paper color
		LIGHTGREEN,	//Ink color
		LIGHTBLUE,	//Grid2Col
		RED,		//Title
		BLACK,		//AxesTitles
		BLUE		//TicLabels
		};

const graphcolors YellowOnBlue={
		BLUE,		//paper color
		YELLOW,		//Ink color
		LIGHTBLUE,	//Grid2Col
		RED,		//Title
		BLACK,		//AxesTitles
		BLUE		//TicLabels
		};

class _Graph : public display, public object
{
 protected:

	int   xxlenp, yylenp,
	      numbheight,
	      yymaxpd,	// relative coord.of paper in frame

	      xtics, ytics,		// number of tic marks
	      xpixtic,ypixtic,	// number of pixels between tics
	      xscale,yscale;	// LOG or LIN - type of scale

	float xval0,yval0,	/* values of x,y at origin		*/
	      xticinc,yticinc,	// increment ofvalue of tic labels
				//  only for LIN scales
	      xvalmax,yvalmax,	/* maximal values of x,y		*/
	      xpixval,ypixval;	/* pixels per unit for x,y		*/

	char *xtitle, *ytitle,	/* axises titles			*/
	     *xticfmt,*yticfmt;	/* formats of tic labels		*/
	//fonts and their sizes
	int axtitlefont,axtitlefontsize,	/*  for axises titles	*/
	    ticfont, ticfontsize;	/*  and tic labels		*/

       plaquecolors framecolors;
       graphcolors grcolors;      // disp colors are inherited
       int gridstyle;		// user defined line style

       int xx0ticlab, xxmaxticlab,yvalwidth;

 public:

 //------ Constructor ---- ALL SIZES IN VGA PIXELS ------
_Graph(
	int _x0,int _y0,	/* where to paint graph*/
	objtype _type,		// may be FIXED,PERM,POPUP
	char *_title,
	int xtics,int ytics,	/* number of x & y div.			*/
	int xpixtic,int ypixtic,// number of pixels between tics

	float _xval0,float _yval0,/* values of x,y (LIN) or powers of 10 (LOG) at origin*/
	float _xvalmax,float _yvalmax,// values of x,y at end of axis
				      //  only for LIN scales
			  //------------ Hereafter are defaults
	void (far *_paintproc)()=procNULL,
	char *xtitle="",char *ytitle="",	// axes titles
	char *xticfmt="",char *yticfmt="", // format of tic labels
					   // can be only float %[..]f
	int _xscale=LIN, int _yscale=LIN,  // may be LIN or LOG
	int _frame=FRAMED, 		   // display may FRAMED or UNFRAMED
	int _titlefont=0,int _titlefontsize=1,	// title
	int axtitlefont=0,int axtitlefontsize=1,  	// tic labels
	int ticfont=SMALL_FONT,int ticfontsize=2,	//div.numbers

	graphcolors graphcolconfig=YellowOnCyan,
	plaquecolors framecolconfig=plaquecoldflt,
	int gridstyle=0x5555);		// style of grid lines
	//---------------------- end of constructor declaration

	void SetupAxisX(
	     float _xval0,// value of x (LIN) or powers of 10 (LOG) at origin
	     float _xvalmax);// values of x at end of axis(only for LIN)

	void SetupAxisY(
	     float _yval0,// value of y (LIN) or powers of 10 (LOG) at origin
	     float _yvalmax);// values of y at end of axis(only for LIN)

	void DrawGrid(void);
	void PrintTicLabelsX(void);
	void PrintTicLabelsY(void);
virtual void Paint(void);
virtual void cls();
	void SetInk(COLORS inkcolor)
		{grcolors.Ink=inkcolor;}

// --- IF color=-1 THE USED CURRENT graphcolors.Ink COLOR.
	//------- DOT & LINE -------
void PutDot( double x, double y, int color=-1);
void PutLine( double x0,double y0,double x1,double y1, int color=-1);

};//++++++++++++++ END of class _Graph ++++++++++++++++++


//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//++++++++++++++ CLASS TEMPLATE  << Graph >>  +++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

template<class XType,class YType>
class Graph : public _Graph
{
 public:

 //------ Constructor ---- ALL SIZES IN VGA PIXELS ------
Graph(
	int _x0,int _y0,	/* where to paint graph*/
	objtype _type,		// may be FIXED,PERM,POPUP
	char *_title,
	int xtics,int ytics,	/* number of x & y div.			*/
	int xpixtic,int ypixtic,// number of pixels between tics

	float _xval0,float _yval0,/* values of x,y (LIN) or powers of 10 (LOG) at origin*/
	float _xvalmax,float _yvalmax,// values of x,y at end of axis
				      //  only for LIN scales
			  //------------ Hereafter are defaults
	void (far *_paintproc)()=procNULL,
	char *xtitle="",char *ytitle="",	// axes titles
	char *xticfmt="",char *yticfmt="", // format of tic labels
					   // can be only float %[..]f
	int _xscale=LIN, int _yscale=LIN,  // may be LIN or LOG
	int _frame=FRAMED, 		   // display may FRAMED or UNFRAMED
	int _titlefont=0,int _titlefontsize=1,	// title
	int axtitlefont=0,int axtitlefontsize=1,  	// tic labels
	int ticfont=SMALL_FONT,int ticfontsize=2,	//div.numbers

	graphcolors graphcolconfig=YellowOnCyan,
	plaquecolors framecolconfig=plaquecoldflt,
	int gridstyle=0x5555) :		// style of grid lines

      _Graph(_x0,_y0,_type,_title,xtics,ytics,xpixtic,ypixtic,_xval0,_yval0,
	_xvalmax,_yvalmax,_paintproc,xtitle,ytitle,xticfmt,yticfmt,
	_xscale,_yscale,_frame,_titlefont,_titlefontsize,
	axtitlefont,axtitlefontsize,ticfont,ticfontsize,
	graphcolconfig,framecolconfig,gridstyle)
	{}
//---------------------- end of constructor Graph::Graph

// --- IF color=-1 THE USED CURRENT graphcolors.Ink COLOR.


	//------- ARRAY ----
void  ShowCurve( int numpoints, XType x0c, XType xmaxc,
					YType far *curve,int color=-1);
void  HideCurve(int numpoints,XType x0c,XType xmaxc,YType far *curve)
	    { ShowCurve(numpoints,x0c,xmaxc,curve,grcolors.Paper);DrawGrid();}

void  ShowHistogram(int numpoints,XType x0a,XType xstep,
				YType far *array, int color=-1);
					// if color=-1 then it is default
void  HideHistogram(int numpoints,XType x0a,XType xstep,
							YType far *array)
	{ ShowHistogram(numpoints,x0a,xstep,array,grcolors.Paper);
	  DrawGrid();}


	//------- TWO ARRAYS ----
 void  ShowCurve(int numpoints, XType far *Xdata,
				      YType far *Ydata, int color);
 void  HideCurve(int numpoints, XType far *Xdata, YType far *Ydata)
	    { ShowCurve(numpoints, Xdata, Ydata, grcolors.Paper);DrawGrid();}

	//------- FUNCTION ----
void  ShowCurve(int numpoints,YType (far *func)(XType ),int color=-1);
void  HideCurve(int numpoints,YType (far *func)(XType ))
		{ ShowCurve(numpoints,func,grcolors.Paper);DrawGrid();}

};//++++++++++++++ END of class Graph ++++++++++++++++++


//---------- TEMPLATES OF MEMBER FUNCTIONS --------

template<class XType,class YType>
void  Graph<XType,YType>::ShowCurve(int numpoints,XType x0c,XType xmaxc,
				YType far *curve, int color)
					// if color=-1 then it is default
{
 int i;
 double dxc, xi, yi;

 setviewport(xx0p,yy0p,xxmaxp,yymaxp,CLIP_ON);
 setcolor((color==-1)?grcolors.Ink:color);
 setlinestyle(SOLID_LINE,0,NORM_WIDTH);

 dxc=(xmaxc-x0c)/(numpoints-1);
 xi = (xscale == LOG) ? log10(x0c) : x0c;
 yi = curve[0];
 if ( yscale == LOG )  yi = ( yi == 0 ) ? yval0 : log10(yi);
 moveto( round( xpixval*( xi - xval0) ),
	  round( ypixval*( yvalmax - yi) ));
 for (i=1;i<numpoints;i++)
  {
    xi = x0c + dxc * i;
    yi = curve[i];
    if ( xscale == LOG )  xi = log10(xi);
    if ( yscale == LOG )  yi = ( yi == 0 ) ? yval0 : log10(yi);
    lineto(  round( xpixval*( xi - xval0 )),
	     round( ypixval*( yvalmax - yi ) ) );
  }// for
}//-------- END of Graph::ShowCurve(,,,YType *) -------------

template<class XType,class YType>
void  Graph<XType,YType>::ShowHistogram(int numpoints,
				XType x0a,XType xstep,
				YType far *array, int color)
					// if color=-1 then it is default
{
 int i, BAR, xi, ybar0, ybar1;
 double xstep2, xbar0, xbar1;

 setviewport(xx0p,yy0p,xxmaxp,yymaxp,CLIP_ON);
 if ( xscale == LOG )
    lgErrExit(" Graph::ShowHistogram : X-scale cannot be LOG for histogram");
 xstep2 = xstep/2.;
 xbar0 = x0a-xval0;
 xbar1 = xbar0+xstep2;
 xbar0 -= xstep2;

 setfillstyle( SOLID_FILL, (color==-1)?grcolors.Ink:color);
 setcolor( (color==-1)? grcolors.Ink : color );
 BAR = ( (xpixval*(xbar1 - xbar0)) < 5 ) ? 0 : 1;
 for ( i=0; i<numpoints; i++)
    {
    double arrayi = array[i];
     if ( yscale == LIN )
      {				// y-LIN
       arrayi = array[i];
       ybar0=( arrayi > 0 ) ?  round( ypixval* (yvalmax - arrayi))
			     : round( ypixval * yvalmax);
       ybar1=( arrayi < 0 ) ?  round( ypixval * (yvalmax - arrayi))
			     : round( ypixval * yvalmax);
       }
     else       		// y-LOG
      {
       ybar0 = ( arrayi == 0 ) ? yylenp :
			    round( ypixval* (yvalmax - log10(array[i])));
       ybar1 = yylenp;
       }
     if ( BAR )
       bar( round( xpixval*(xbar0 + xstep*i)) + 2, ybar0,
	    round(xpixval*(xbar1 + xstep*i)) - 2, ybar1);
     else
      {xi =  round( xpixval*(x0a - xval0 + xstep*i));
       line( xi, ybar0, xi, ybar1);}
    } /* for */

}//-------- END of Graph::ShowHistogram(,,,YType*) ----

template<class XType,class YType>
void  Graph<XType,YType>::ShowCurve(int numpoints,
					  XType far *Xdata,
					  YType far *Ydata, int color)
{					// if color=-1 then it is default
int i;
 double xi, yi;

 setviewport(xx0p,yy0p,xxmaxp,yymaxp,CLIP_ON);
 setcolor((color==-1)?grcolors.Ink:color);

 xi = Xdata[0];
 if ( xscale == LOG )  xi = ( xi == 0 ) ? xval0 : log10(xi);
 yi = Ydata[0];
 if ( yscale == LOG )  yi = ( yi == 0 ) ? yval0 : log10(yi);
 moveto(  round( xpixval*( xi - xval0)),
	  round( ypixval*( yvalmax - yi) ));
 for (i=1;i<numpoints;i++)
  {
    xi = Xdata[i];
    yi = Ydata[i];
    if ( xscale == LOG )  xi = log10(xi);
    if ( yscale == LOG )  yi = ( yi == 0 ) ? yval0 : log10(yi);
    lineto(  round( xpixval*( xi - xval0 )),
	     round( ypixval*( yvalmax - yi )) );
  }// for
}//-------- END of Graph::ShowCurve(,,,XType *x,YType *y) -------------


template<class XType,class YType>
void  Graph<XType,YType>::ShowCurve(int numpoints,
					  YType (far *func)(XType),
					  int color)
{					// if color=-1 then it is default
int i;
double  xi, yi, dxc, xval0c, xvalmaxc ;

 setviewport(xx0p,yy0p,xxmaxp,yymaxp,CLIP_ON);
 setcolor((color==-1)?grcolors.Ink:color);
 if ( xscale == LOG )
	{xval0c = pow10(xval0);	xvalmaxc = pow10(xvalmax); }
 else   {xval0c = xval0;	xvalmaxc = xvalmax; }
 dxc = ( xvalmaxc - xval0c ) / (numpoints-1) ;
 yi = (*func)( xval0c );
 if ( yscale == LOG ) 	yi = ( yi == 0 ) ? yval0 : log10( yi ) ;
 moveto( 0,  round( ypixval * ( yvalmax - yi ) ) );

 for (i=1;i<numpoints;i++)
    {xi = xval0c + dxc*i;
     yi = (*func)( xi );
     if ( xscale == LOG )  xi = log10(xi);
     if ( yscale == LOG )  yi = ( yi == 0 ) ? yval0 : log10( yi ) ;
     lineto(  round( xpixval * (xi - xval0) ),
	      round( ypixval * (yvalmax - yi)) );
     }
}//--------- END of _Graph::ShowCurve(,,, *()) ---------------

#endif  // __VPGRAPH_H
