//	GRAPH WITH MARKER
//
//		VPGRWMAR.H: CLASS TEMPLATE   TSGraph 
//
//	APPLICATION FOR VIRTUAL PANELS
//
//	Written by O.Rasizade, 1993
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#include <lgindic.h>

#ifndef __cplusplus
#error Must use C++ for the type GraphWithMarker
#endif

#ifndef __VPGRWMAR_H
#define __VPGRWMAR_H

#define BUTT_HEIGHT	18
#define BUTT_FONT   	SMALL_FONT
#define BUTT_FONT_SIZE	4
#define MARKER_OFFSET	30
#define XT_INT		1
#define XT_FLOAT	0


template<class XType,class YType>
class GraphWithMarker : public Graph<XType,YType>
{
 protected:
   YType far *pfArray;
   int xtype;		// type of x,may be XT_INT or XT_FLOAT

   int iN;		// size of arrays
   int iNdisp;		// size of displayed part of arrays

   XType xabsval0, xabsvalmax;	// start and end of whole array
   double dxi;		// xvalue per index of array
   int  index0, indexmax, indexleft, indexright, indexdel;
   char * xindfmt, * yindfmt;	// format for indicators

   XType xmarker, xmarkerl, xmarkerr;	// coord of markers: central, left, right
   YType ymarker;

   Indicator<XType>  *pindX;
   Indicator<YType>  *pindY;

   int  XorMarker(int index);	// returns current value of index of marker
   int  ShowFullSize(void);     // show array in full size, returns index of marker

 public:

 //------ Constructor ---- ALL SIZES IN VGA PIXELS ------
GraphWithMarker(int _iN, YType far *_pfArray,
	int _xtype,			// may be XT_INT or XT_FLOAT
	char * _xindfmt, char * _yindfmt, // format for indicators
	int _x0,int _y0,	/* where to paint graph*/
	objtype _type,		// may be FIXED,PERM,POPUP
	char *_title,
	int xtics,int ytics,	/* number of x & y div.			*/
	int xpixtic,int ypixtic,// number of pixels between tics

	float _xval0,float _yval0,/* values of x,y (LIN) or powers of 10 (LOG) at origin*/
	float _xvalmax,float _yvalmax,// values of x,y at end of axis
				      //  only for LIN scales
			  //------------ Hereafter are defaults
	void (far *_paintproc)()=procNULL,
	char *_xtitle="",char *_ytitle="",	// axes titles
	char *xticfmt="",char *yticfmt="", // format of tic labels
					   // can be only float %[..]f
	int _xscale=LIN, int _yscale=LIN,  // may be LIN or LOG
	int _frame=FRAMED, 		   // display may FRAMED or UNFRAMED
	int _titlefont=0,int _titlefontsize=1,	// title
	int axtitlefont=0,int axtitlefontsize=1,  	// tic labels
	int ticfont=SMALL_FONT,int ticfontsize=2,	//div.numbers

	graphcolors graphcolconfig=YellowOnCyan,
	plaquecolors framecolconfig=plaquecoldflt,
	int gridstyle=0x5555) :		// style of grid lines

      Graph<XType,YType>(_x0,_y0,_type,_title,xtics,ytics,xpixtic,ypixtic,_xval0,_yval0,
	_xvalmax,_yvalmax,_paintproc,_xtitle,_ytitle,xticfmt,yticfmt,
	_xscale,_yscale,_frame,_titlefont,_titlefontsize,
	axtitlefont,axtitlefontsize,ticfont,ticfontsize,
	graphcolconfig,framecolconfig,gridstyle)

	{
	   iN = iNdisp = _iN;
	   index0 = 0;	 indexmax = iN - 1;
	   xtype = _xtype;
	   dxi = (xvalmax - xval0) / (iN - 1);
	   pfArray = _pfArray;
	   xabsval0 = _xval0 ;	xabsvalmax = _xvalmax;
	   xindfmt = _xindfmt;	yindfmt = _yindfmt;
	   xmarker = (xvalmax + xval0)/2;
	   ymarker = (yvalmax + yval0)/2;
	   yymax += BUTT_HEIGHT + 10;
	   ymax=y__yy(yymax);
int y0ind = y__yy( yymaxp+SHADWIDTH+XNOTCHLENGTH+ numbheight+ 2*yyspacing);
	pindY = new Indicator<YType>
			( x0, y0ind, FIXED, ytitle, 15,
			  &ymarker, yindfmt,
			  UNFRAMED,procDummy,
			  SMALL_FONT,4,		//font and size of number
			  SMALL_FONT,4);	//font and size of title

	pindX = new Indicator<XType>
			( pindY->xmax, y0ind, FIXED, xtitle, 15,
			  &xmarker, xindfmt,
			  UNFRAMED,procDummy,
			  SMALL_FONT,4,	//font and size of number
			  SMALL_FONT,4);	//font and size of title

	 }
//---------------------- end of constructor GraphWithMarker::GraphWithMarker

//---------------------DESTRUCTOR -----------
~GraphWithMarker(void)
 {
    delete  pindX;
   delete  pindY;
 }

//-------------------------- METHODS ----------
virtual void Paint(void);
 void Marker(void);	// returns current value of index of Array
 void InstallArray(YType far *pfArr) { pfArray = pfArr;}
 void FindMinMax( YType &max, YType &min);
 };

//--------------------------- IMPLICATION OF METHODS -----

//------------------------------- PAINT
template<class XType,class YType>
 void GraphWithMarker<XType,YType>::Paint(void)
 {
  Graph<XType,YType>::Paint();
  pindX->Paint();
  pindY->Paint();
  setcolor( RED );
  maxviewport;
  settextstyle( SMALL_FONT, HORIZ_DIR, 4);
  settextjustify(LEFT_TEXT, TOP_TEXT);
  outtextxy( pindX->xxmax, (pindX->yymax+pindX->yy0)/2,
	      "Enter-Zoom Home \'+\'\'-\' PgUp PgDn");
 }

//--------------------------------- XOR MARKER, PROTECTED
template<class XType,class YType>
 int GraphWithMarker<XType,YType>::XorMarker(int index)
{
  if ( index0 < 0)
   index0 = 0 ;
  if ( indexmax >= iN )
   indexmax = iN - 1;

  if ( index < index0 )
   index = index0 ;
  if ( index > indexmax )
   index = indexmax ;

  indexleft =  index - indexdel;
  indexright = index + indexdel;

  if ( indexleft < index0 )
   indexleft = index0 ;
  if ( indexleft > index )
   indexleft= index ;

  if ( indexright < index )
   indexright = index ;
  if ( indexright > indexmax)
   indexright = indexmax ;

  if ( xtype == XT_INT )
   {
     xmarker  = xabsval0 + round(index * dxi);
     xmarkerl = xabsval0 + round(indexleft * dxi);
     xmarkerr = xabsval0 + round(indexright * dxi);
    }
  else
   {
     xmarker = xabsval0 + index * dxi;
     xmarkerl = xabsval0 + round(indexleft * dxi);
     xmarkerr = xabsval0 + round(indexright * dxi);
    }

  setlinestyle(SOLID_LINE,0,NORM_WIDTH);
  setwritemode(XOR_PUT);
  PutLine(xmarker,yvalmax,xmarker,yval0, WHITE);
  PutLine(xmarkerl,yvalmax,xmarkerl,yval0, CYAN);
  PutLine(xmarkerr,yvalmax,xmarkerr,yval0, CYAN);

  setwritemode(COPY_PUT);
  return index;
}

//---------------------------------- SHOW ARRAY FULL SIZE, protected
//------------ return index of the marker
 template<class XType,class YType>
 int GraphWithMarker<XType,YType>::
   ShowFullSize(void)
{
int index;
YType MaxY, MinY;

 index0 = 0;
 indexmax = round( (xabsvalmax - xabsval0)/dxi );
 index    = (indexmax + index0)/2;
 indexdel = (indexmax - index0)/8;

 FindMinMax( MaxY, MinY);
 pgrSpectra->SetupAxisX( xabsval0, xabsvalmax);
 pgrSpectra->SetupAxisY( MinY, MaxY);
 pgrSpectra->PrintTicLabelsX();
 pgrSpectra->PrintTicLabelsY();

  iNdisp = indexmax - index0 + 1;
  cls();
  ShowCurve( iNdisp, xval0, xvalmax, pfArray);
  return index;
}//------------ ShowFullSize(void) -----

//-------------------------------- MARKER
template<class XType,class YType>
 void GraphWithMarker<XType,YType>::Marker(void)
{
int ch, index;
YType MaxY, MinY;

  index = ShowFullSize();
  XorMarker(index);
int indexmax_0;
float factor = 2.;

  while ( ( ch =getch()) != 27 )// while esc
   {
    switch ( ch )
     {
	case 43:		// + - scale Y up
		Enter("Enter Factor", "Stretch by:","%f",
						&factor, 18);
		pgrSpectra->SetupAxisY( yval0, yval0 +
					(yvalmax - yval0)*factor);
		pgrSpectra->PrintTicLabelsY();
		cls();
		ShowCurve( iNdisp, xval0, xvalmax, pfArray + index0);
		goto display;

	case 45:		// '-' - scale Y up
		Enter("Enter Factor", "Shrink by:","%f",
						&factor, 18);
		pgrSpectra->SetupAxisY( yval0, yval0 +
					(yvalmax - yval0)/factor);
		pgrSpectra->PrintTicLabelsY();
		cls();
		ShowCurve( iNdisp, xval0, xvalmax, pfArray + index0);
		goto display;

	case 13:	// Enter - zoom
	       if ( indexleft < indexright )
		{
		index0   = indexleft;
		indexmax = indexright;
		index    = (indexmax + index0)/2;
		indexdel = (indexmax - index0)/8;

		iNdisp   = indexmax - index0 + 1;
		FindMinMax( MaxY, MinY);

		pgrSpectra->SetupAxisX( xmarkerl, xmarkerr);
		pgrSpectra->SetupAxisY( MinY, MaxY);
		pgrSpectra->PrintTicLabelsX();
		pgrSpectra->PrintTicLabelsY();
		cls();
		ShowCurve( iNdisp, xval0, xvalmax, pfArray + index0);
	       }
		goto display;

     case 0:
	     switch (getch())
	     {
	       case 73:		// Page Up - scroll right
		indexmax_0 = (indexmax - index0)/2;
		if ( indexmax + indexmax_0 < iN )
		{
		 index0 += indexmax_0;
		 indexmax += indexmax_0;
		 index    += indexmax_0;
		 }
		else
		 {
		  indexmax = iN - 1;
		  index0   = indexmax - 2*indexmax_0;
		  index    = index0 + indexmax_0;
		 }
		 goto display1;

	       case 81:		// Page Down - scroll left
		indexmax_0 = (indexmax - index0)/2;
		if ( index0 - indexmax_0 > 0 )
		{
		 index0 -= indexmax_0;
		 indexmax -= indexmax_0;
		 index    -= indexmax_0;

		}
		else
		 {
		  index0 = 0;
		  indexmax = index0 + 2*indexmax_0;
		  index = index0 + indexmax_0;
		 }
		goto display1;

	       case 71:		// Home - restore
		 index = ShowFullSize();
		 goto display;

	       case 80:		// down arrow - narrow window
		 XorMarker(index);
		 indexdel--;
		 goto display;

	       case 72:		// up arrow - widen window
		 XorMarker(index);
		 indexdel++;
		 goto display;

	       case 75:		// left arrow - marker left fast
		 XorMarker(index);
		 index -= MARKER_OFFSET;
		 goto display;

	       case 77:		// right arrow - marker right fast
		 XorMarker(index);
		 index += MARKER_OFFSET;
		 goto display;

	       case 115:	// Ctrl-left arrow - marker left slowly
		 XorMarker(index);
		 --index;
		 goto display;

	       case 116:	// Ctrl-right arrow - marker right slowly
		 XorMarker(index);
		 ++index;
		 goto display;

	      display1:
		if ( xtype == XT_INT )
		   {
		     xval0   = xabsval0 + round(index0 * dxi);
		     xvalmax = xabsval0 + round(indexmax * dxi);
		    }
		else
		   {
		     xval0   = xabsval0 + index0 * dxi;
		     xvalmax = xabsval0 + indexmax * dxi;
		    }

		pgrSpectra->SetupAxisX( xval0, xvalmax);
		pgrSpectra->PrintTicLabelsX();
		iNdisp   = indexmax - index0 + 1;
		cls();
		ShowCurve( iNdisp, xval0, xvalmax, pfArray + index0);

	      display:
		index = XorMarker(index);
		ymarker = pfArray[index];
		pindX->Refresh();
		pindY->Refresh();
	      }//switch(  second char )
	}//switch(  first char )
   }//while
 XorMarker(index);
}//------------ void Marker(void) -------

//----------------------- FIND MIN AND MAX VALUE OF ARRAY, PROTECTED
template<class XType,class YType>
 void GraphWithMarker<XType,YType>::
      FindMinMax(YType &max,YType &min)
{
max=pfArray[index0];  min=pfArray[index0];
 for (int i=index0; i <= indexmax; i++)
  {
    if (max < pfArray[i]) max = pfArray[i];
    if (min > pfArray[i]) min = pfArray[i];
   }
 if ( max == min )
      max = 1 + min;
} // FindMinMaxXt


#endif  // __VPGRWMAR_H