//
//   VIRTUAL PANELS * GRAPHIC USER UNTERFACE FOR LABORATORY WORKS
//
//		VPINBOX.H : CLASSES: Inbox, TSInbox
//
//                       |	 Written by O.Rasizade
//    declarations       | 	  Sept 1992, 1993
//                       |
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

#ifndef __cplusplus
#error Must use C++ 
#endif

#ifndef __VPINBOX_H
#define __VPINBOX_H



#if !defined(__VPOUTBOX_H)
#include <vpoutbox.h>
#endif

#if !defined(__VPBUTT_H)
#include <vpbutt.h>
#endif

//+++++++++++++++++++++++++++++++++++++++++++++++++
//++++++++++++ CLASS   << Inbox >>  +++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++
//---------------------- COLORS -------------------------
const outboxcolors ibxcolLum={
		       BLUE,		// color of title
		       LIGHTGREEN,	// text color
		       YELLOW,		// high-lighted text
		       BLACK            // color of paper
		       };


const outboxcolors ibxcolGray={
		       BLUE,		// color of title
		       YELLOW,		// text color
		       WHITE,		// high-lighted text
		       LIGHTGRAY        // color of paper
		       };

//------------------------------ Class declaration  --

class Inbox: public Outbox
{
void  XorCursor(void);
friend void interrupt handler(...); // cursor formation

public:

  //----- Constructor ------- All coord. and sizes in VGA pixels ----
 Inbox(
	int _x0,int _y0,// left top coord where to paint the box
	objtype _type,	// may be FIXED,PERM,POPUP
	char *_title, 	// title
	int columns,	// size of box
				//---------- Hereafter are defaults
	int _frame=FRAMED,		// display may FRAMED or UNFRAMED
	void (far *_paintproc)()=procNULL,// proc created by programmer
					   // to repaint box, only for PERM
	int  _titlefont=0,int _titlefontsize=1,	//font and size of title
	plaquecolors obxcolcnfg=plaquecoldflt,  //colors of board
	outboxcolors _ibxcolors=ibxcolGray,
	int _titlejustify=CENTER_TEXT) :

	Outbox (_x0,_y0,_type,_title,  columns,1,// size of box
		_frame,_paintproc,_titlefont,_titlefontsize,
		0,1,/*font of text*/  obxcolcnfg,/*colors of board*/
		_ibxcolors, _titlejustify) {}
// Scanf returns: 0 if Shift-Tab has been pushed
//	   	  9 if Tab
//		 13 if CR
//		 27 if ESC
//		 -1 if no data has been entered
int  Scanf(const char *fmt,...);
};//++++++++++++++ END of class Inbox+++++++++++++++++++



//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//++++++++++++++ CLASS   << TSINBOX >>  ++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
template <class T>
class TSInbox: public tabstop, public Inbox
{
protected:

 char *scanfmt;		// format of variable for scanf
 char *printfmt;	// format of variable for scanf
 T    *variable;	// ptr to variable accosiated with Inbox
 T (far *proc)(T);   // processing of entered value if need

 public:
TSInbox(
	int _x0,int _y0,// left top coord where to paint the box
	char *_title, 	// title
	int columns,	// size of box
	T *_variable, // variable and its formats
	char *_scanfmt,
	char *_printfmt,
				//---------- Hereafter are defaults
        T (far *_proc)(T) = NULL, // variable processing procedure,
	int  _titlefont=SMALL_FONT,int _titlefontsize=4,//font and size of title
	plaquecolors obxcolcnfg=plaquecoldflt,  //colors of board
	outboxcolors _ibxcolors=ibxcolGray) :

	Inbox( _x0, _y0, FIXED, _title, columns, UNFRAMED, procNULL,
	       _titlefont, _titlefontsize,
	       obxcolcnfg, _ibxcolors, LEFT_TEXT),

	tabstop()
{
  scanfmt=_scanfmt; printfmt=_printfmt;
  variable=_variable; proc = _proc;
 }

 void  Refresh(void)
	{ cls(); Printf(0,printfmt,*variable); }
 virtual void  Activate(void);
 virtual void  Deactivate(void)
	{ Refresh(); }
};

//----------- BODIES OF TEMPLATES ----
template <class T>
 void  TSInbox<T>::Activate(void)
{
 int msg;
 cls();
 Printf(1,printfmt,*variable);
int ch=getch(); cls(); ungetch(ch);
 switch ( Scanf(scanfmt,variable) )
     {
      case  0:
	       msg = MSG_PREVTABSTOP;	// Shift-Tab
	       goto process;
      case  9:				// Tab
      case 13:
	       msg = MSG_NEXTTABSTOP;	// Enter
	       goto process;
      case 27:
	       msg = MSG_EXIT;		// ESC
      process: butsystem::SendMessage( msg );
	       if ( proc!=NULL )
		     *variable = proc( *variable );
	       break;
      case -1: beep;		// Format error
      }
}

#endif // __VPINBOX_H
