//
//  VIRTUAL PANELS * GRAPHIC USER UNTERFACE FOR LABORATORY WORKS
//
//		VPINDIC.H : CLASS: Indicator
//
//                       |	 Written by O.Rasizade
//    declarations       | 	   Sept 1992, 1993
//                       |
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

#ifndef __cplusplus
#error Must use C++ 
#endif

#ifndef __VPINDIC_H
#define __VPINDIC_H


//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//++++++++++++++ CLASS   << Indicator >>  +++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

struct indicatorcolors{ COLORS
		       title,	// color of title
		       foregr,	// foreground color
		       backgr;	// background color
		       };

const indicatorcolors LEDind={
		       BLUE,	// color of title
		       LIGHTRED,// foreground color
		       RED	// background color
		       };
const indicatorcolors LUMind={
		       BLUE,	// color of title
		       LIGHTGREEN,// foreground color
		       BLACK	// background color
		       };

const indicatorcolors LCDdark={
		       BLUE,	// color of title
		       DARKGRAY,// foreground color
		       BROWN	// background color
		       };

const indicatorcolors LCDbright={
		       BLUE,	// color of title
		       DARKGRAY,// foreground color
		       YELLOW	// background color
		       };

class _Indicator: public display,public object
{
protected:
  int dispwid;		// display width in chars
  char *fmt;		// format
  int  numbfont,numbfontsize;	// font and size of number

  plaquecolors indframecolors;
  indicatorcolors indcolors;	// disp colors are inherited

 public:

  //------- Constructor ------ All coord. and sizes in VGA pixels ----
  _Indicator(
	int _x0,int _y0,// left top coord where to paint the indicator
	objtype _type,	// may be FIXED,PERM,POPUP
	char *_title, 	// title
	int dispwidth,	// display width in chars
	char *format,  //  format
			  // Hearafter are defaults
	int _frame=UNFRAMED,		// display may FRAMED or UNFRAMED
	void (far *_paintproc)()=procNULL,// proc created by programmer
				  // to repaint indicator, only for PERM

	int  numberfont=0,int numberfontsize=1,//font and size of number
	int  _titlefont=0,int _titlefontsize=1,	//font and size of title

	plaquecolors indframecolcnfg=plaquecoldflt,// colors of frame
	indicatorcolors indcolcnfg=LCDdark);  // colors of screen and numbers
	//-------- end of constructor declaration ------

virtual void  Paint(void);
	void  Put(...);
	void  Puts(char *str);
//also  void cls() inherited from display
};

template <class T>
class Indicator: public _Indicator
{
 T * variable;

 public:

  //------- Constructor ------ All coord. and sizes in VGA pixels ----
 Indicator(
	int _x0,int _y0,// left top coord where to paint the indicator
	objtype _type,	// may be FIXED,PERM,POPUP
	char *_title, 	// title
	int dispwidth,	// display width in chars
	T *_variable, char *format,  //  format of varible's output
			  // Hearafter are defaults
	int _frame=UNFRAMED,		// display may FRAMED or UNFRAMED
	void (far *_paintproc)()=procNULL,// proc created by programmer
				  // to repaint indicator, only for PERM

	int  numberfont=0,int numberfontsize=1,//font and size of number
	int  _titlefont=0,int _titlefontsize=1,	//font and size of title

	plaquecolors indframecolcnfg=plaquecoldflt,// colors of frame
	indicatorcolors indcolcnfg=LCDdark):  // colors of screen and numbers

   _Indicator(_x0,_y0,_type,_title, dispwidth, format, _frame,
	      _paintproc, numberfont, numberfontsize,
	      _titlefont, _titlefontsize, indframecolcnfg, indcolcnfg)
{ variable = _variable; }

 void  Refresh(void)
	{ cls(); Put(*variable); }

};//++++++++++++++ END of class Indicator +++++++++++++++++++

#endif // __VPINDIC_H