//
//   VIRTUAL PANELS * GRAPHIC USER UNTERFACE FOR LABORATORY WORKS
//
//		VPOUTBOX.H : CLASS: Outbox
//
//                       |	 Written by O.Rasizade
//    declarations       | 	   Sept 1992, 1993
//                       |
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

#ifndef __cplusplus
#error Must use C++ 
#endif

#ifndef __VPOUTBOX_H
#define __VPOUTBOX_H



#if !defined(__VPBOARD_H)
#include "..\\vp\\vpboard.h"
#endif

//+++++++++++++++++++++++++++++++++++++++++++++++++
//++++++++++++ CLASS   << OUTBOX >>  +++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++

struct outboxcolors {COLORS
		   title,
		   text,
		   hltext,	//high-lighted text
		   paper;
		    };

const outboxcolors obxcoldflt={
		       RED,		// color of title
		       WHITE,		// text color
		       YELLOW,		//high-lighted text
		       LIGHTGRAY	// color of paper
		       };

	// Error Message Box Colors
const plaquecolors errboxcolors={
			 RED,		// PlaqeColor
			 RED,		// shadow
			 LIGHTRED	// ltnd
			};
const outboxcolors errcolors={
		       WHITE,		// color of title
		       WHITE,		// text color
		       YELLOW,		//high-lighted text
		       RED		// color of paper
		       };

//------------------------------ Class declaration  --

class Outbox: public object ,public display
{
  int bkgnd;	// flag, if nonzero then backgr.color will be printed
		//          for LEFT_TEXT
protected:

  int textfont,textfontsize;
  int xtextjust;	// x current text justify
  int columns,rows;	// size of display
//------- "Cursor" position are in pixels, not like text mode !
  int xtext,ytext;	// "cursor" location in box rel. to paper coord.
  int xtext0;		// LF location
  int titlejustify;

  plaquecolors obxframecolors;	// colors of frame
  outboxcolors obxcolors;

 public:

  //----- Constructor ------- All coord. and sizes in VGA pixels ----
 Outbox(
	int _x0,int _y0,// left top coord where to paint the box
	objtype _type,	// may be FIXED,PERM,POPUP
	char *_title, 	// title
	int columns,int rows,  	   // size of box
				//---------- Hereafter are defaults
	int _frame=FRAMED,		// display may FRAMED or UNFRAMED
	void (far *_paintproc)()=procNULL,// proc created by programmer
					   // to repaint board, only for PERM
	int  _titlefont=0,int _titlefontsize=1,	//font and size of title
	int  _textfont=SMALL_FONT,int _textfontsize=5,	//font and size of text
	plaquecolors obxcolcnfg=plaquecoldflt,  //colors of board
	outboxcolors _obxcolors=obxcoldflt,
	int _titlejustify=CENTER_TEXT);

virtual void  Paint(void);
  void  SetTextJustify(text_just xtj=LEFT_TEXT);// justifies text
				// xtj may be LEFT_TEXT,CENTER_TEXT,RIGHT_TEXT
virtual	void  cls(); //also initializes variables
  void  GotoXY(int x,int y)	// sets cursor position
	{xtext=x+xxspacing; 		        // goto to bottom if y=-1
	 ytext=(y==-1)?yymaxp-yy0p-textheight("H")-yyspacing:y+yyspacing;}
  void  GetXY(int *x,int *y)      // get cursor position
			{*x=xtext;*y=ytext;}
  void  SetTextColor(COLORS newcolor)
			{obxcolors.text=newcolor;}
  void  SetHLTextColor(COLORS newcolor)
			{obxcolors.hltext=newcolor;}
  void  YesBkgnd(void)
			{bkgnd=1;}
  void  NoBkgnd(void)
			{bkgnd=0;}

// Print members print text bkgrnd only for LEFT_TEXT justify

	void  Put(char *text,int hilight=OFF);
	void  Putn(char *text,int hilight=OFF);
	int   Printf(int hilight, const char *fmt, ...);
	int   Printfn(int hilight, const char *fmt, ...);

};//++++++++++++++ END of class Outbox+++++++++++++++++++

#endif // __VPOUTBOX_H
