//
//	     UTILITY BOXES FOR VirtualPanels APPLICATIONS
//	
//	     VPUTIL.CPP: 
//		    FUNCTIONS :
//			void DisplayMessage(char *title,char *mess)
//			void DisplayErrorMessage(char *mess)
//			int  Confirm(char *mess)
//			void far bpHelp()
//
//                       |	 Written by O.Rasizade
//    			 | 	  1993
//                       |
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#include "vphead.h"	// must be included first
#pragma hdrstop


#include <vpbase.h>
//#include <vpboard.h>
#include <vpoutbox.h>
//#include <vpinbox.h>
//#include <vpindic.h>
//#include <vpgraph.h>
#include <vpbutt.h>
#include <vputil.h>

//------------------------- DISPLAY MESSAGE BOX ---------

void _Cdecl DisplayMessage(char *title,char *mess)
{
 beep;
Outbox Message(maxx>>2,maxy>>2,POPUP,title,strlen(mess),1,FRAMED,procNULL,0,1,0,1);
 Message.Paint();
 Message.Put(mess,1);
 getch();
 Message.Remove();
}

//------------------------- DISPLAY ERROR MESSAGE BOX ----

void _Cdecl DisplayErrorMessage(char *mess)
{
 beep;
Outbox Message(maxx>>2,maxy>>2,POPUP,"Error",strlen(mess),1,FRAMED,
	procNULL,0,1,0,1,errboxcolors,errcolors);
 Message.Paint();
 Message.Put(mess);
 getch();
 Message.Remove();
}

//--------------------------------  CONFIRM BOX ----------
//----- returns FALSE if 'No' button was pressed,
//-----         TRUE     'Yes'
int resp; 	// Status register 1- Yes,  0 - No
butsystem *pbsYN;

void far bpYes(void)
	{ resp=1; pbsYN->SendMessage(MSG_EXIT);} // exit Loop
void far bpNo(void)
	{ resp=0; pbsYN->SendMessage(MSG_EXIT);} // exit Loop

int _Cdecl Confirm(char *mess,int dflt)
{
resp = dflt;
pbsYN = new butsystem;

Outbox Ask( maxx>>2, maxy>>2, POPUP, "Confirm",
			strlen(mess)+2, 5,  // size of box
			FRAMED, procNULL, 0,1, 0,1);// title and text fonts
butgrp YesNo( (Ask.xmax+Ask.x0-110)>>1, Ask.ymax-40, 50, 21, HORIZ, 10);
 button Yes("Yes",'y','Y',bpYes);
 button No("No",'n','N',bpNo);

 Ask.Paint();
 Ask.Putn("");
 Ask.Put( mess,1);
 YesNo.Paint();
 pbsYN->NextButton();
 if ( dflt == NO )
   pbsYN->NextButton();
 pbsYN->Loop(procDummy);
 delete pbsYN;
 Ask.Remove();
 return resp;	// return TRUE if Yes, FALSE if No
}


//----------------------------- HELP ---

extern Outbox *obxHelp;

void far _Cdecl bpHelp(void)
{		// popup output box
#define	hN  8	// number of rows of help text
int i;
  //------------- Help text
char *txt[2][hN]=
 {
 {"Alt-F3","Ctrl-F5","F6","Left,Right,Up,Down","Ctrl-Left,Right,Up,Down",
    "Tab","Shift-Tab","Esc"},
  {"close window", "start dragging object", "switch between objects",
   "quick drag", "slow drag",
   "go to next button group", "go to prev. button group",
   "quit"}
  };

 obxHelp->Paint();
 obxHelp->MkActive();
		// hilight text output
 for (i=0;i<hN;i++) obxHelp->Printfn(1,txt[0][i]);

 obxHelp->GotoXY(0,0);
 obxHelp->SetTextJustify(RIGHT_TEXT);	// normal text output
 for (i=0;i<hN;i++) obxHelp->Putn(txt[1][i]);

 obxHelp->GotoXY(0,-1); 	// put cursor at bottom of box
 obxHelp->SetTextJustify(CENTER_TEXT);
 obxHelp->SetTextColor(LIGHTGREEN);
 obxHelp->Put("Press any key...");
 obxHelp->SetTextColor(WHITE);
 getch();
 obxHelp->Remove();
}//--- END of bpHelp() ---
