unit adapter;
{
written by Michael D. McCall  ==>  M-McCall@bgu.edu
}
interface

    (******************************************************) function
videoType : char;
    {checks the active video adapter and returns:
        U=Unknown
        M=MCGA
        V=VGA
        E=EGA
        C=CGA
        H=Hercules
        D=MDA
     adapter type determined using techniques from
     Programmer's Guide to PC & PS/2 VIDEO SYSTEMS by Richard Wilton
    }


implementation

var x : byte;
    portAddress : word;

    (******************************************************) function
is6845here : boolean;

    begin
    inline (
        $8B/$16/portAddress/ {mov DX, portAddress                           }
        $B0/$0F/             {mov AL, 0F                                    }
        $EE/                 {out DX, AL     select 6845 reg 0F (cursor low)}
        $42/                 {inc DX                                        }
        $EC/                 {in  AL, DX     current cursor low value       }
        $88/$C4/             {mov AH, AL     preserve in AH                 }
        $B0/$66/             {mov AL, 66     arbitrary value                }
        $EE/                 {out DX, AL     try to write to 6845           }
        $B9/$00/$01/         {mov CX, 100                                   }
{here}  $E2/$FE/             {loop here      wait for 6845 to respond       }
        $EC/                 {in  AL, DX                                    }
        $86/$E0/             {xchg AH, AL    al=original, ah=returned       }
        $EE/                 {out DX, AL     restore original value         }
        $88/$26/x);          {mov turbo_variable_x, AH                      }
    is6845here := x = $66;
    end;

    (******************************************************) function
isHERC : boolean;

    begin
    portAddress := $3BA;   {CRT controller status port}
    inline (
        $8B/$16/portAddress/ {mov DX, portAddress                            }
        $EC/                 {in  AL, DX                                     }
        $24/$80/             {and AL, 80                                     }
        $88/$C4/             {mov AH, AL           bit 7=vertical sync on HGC}
        $B9/$00/$80/         {mov CX, 8000         do this 32768 times       }
{here}  $EC/                 {in  AL, DX                                     }
        $24/$80/             {and AL, 80                                     }
        $38/$C4/             {cmp AH, AL           has bit 7 changed         }
        $E1/$F9/             {loope here           wait for bit 7 to change  }
        $A3/portAddress);    {mov portAddress, AX  bit 7 changes on a HERC   }
    isHERC := hi (portAddress) <> lo (portAddress);
    end;

    (******************************************************) function
MDAvsHERC : char;

    begin
    portAddress := $3B4;          { I/O port of MDA & HERC's CRT controller  }
    if NOT is6845here then        { not Motorola 6845 means unknown adapter  }
        MDAvsHERC := 'U'
    else if isHERC then
        MDAvsHERC := 'H'
    else
        MDAvsHERC := 'D';
    end;

    (******************************************************) function
videoType : char;

    begin
    videoType := 'U';
    {test for int $10 function $1A, found with VGAs and MCGAs}
    inline (
        $B8/$00/$1A/           {mov AX, 1A00}
        $CD/$10/               {int 10}
        $A2/x/                 {mov x, AL}
        $88/$1E/portAddress);  {mov portAddress, BL}
    if x = $1A then    { function $1A returns $1A in AL if supported  }
        case lo (portAddress) of  { active adapter is returned in BL  }
            1 : videoType := MDAvsHERC;
            2 : videoType := 'C';
         4, 5 : videoType := 'E';
            6 : videoType := 'P';
         7, 8 : videoType := 'V';
         $A, $B, $C : videoType := 'M';
        end
    else              { function $1A is not supported  }
        begin   { test for int $10 function $12, found with EGA's  }
        inline (
            $B3/$10/           {mov BL, 10       arbitrary value}
            $B4/$12/           {mov AH, 12}
            $CD/$10/           {int 10}
            $88/$1E/x);        {mov x, BL}
        if x <> $10 then   { if BL is changed by function 12, we have an EGA  }
            videoType := 'E'
        else
            begin   {   test for CGA   }
            portAddress := $3D4;   {I/O port of CGA CRT controller }
            if is6845here then    {    is CGA    }
                videoType := 'C'
            else
                videoType := MDAvsHERC;
            end;
        end;
    end;
end.